/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;

public final class Encryption {
    private final InputInfo info;
    private static final byte[] SYM = Token.token("symmetric");
    private static final byte[] BASE64 = Token.token("base64");
    private static final byte[] HEX = Token.token("hex");
    private static final TokenMap ALGE = new TokenMap();
    private static final TokenMap ALGN = new TokenMap();
    private static final TokenMap ALGHMAC = new TokenMap();
    private static final byte[] DEFA = Token.token("md5");
    private static final byte[] DES = Token.token("des");

    public Encryption(InputInfo ii) {
        this.info = ii;
    }

    public Str encryption(byte[] in, byte[] s, byte[] k, byte[] a, boolean ec) throws QueryException {
        boolean symmetric = Token.eq(Token.lc(s), SYM) || s.length == 0;
        byte[] aa = a.length == 0 ? DES : a;
        byte[] tivl = ALGE.get(Token.lc(aa));
        if (!symmetric) {
            throw Err.CX_ENCTYP.get(this.info, ec);
        }
        if (tivl == null) {
            throw Err.CX_INVALGO.get(this.info, new Object[]{s});
        }
        int ivl = Token.toInt(tivl);
        byte[] t = null;
        try {
            t = ec ? Encryption.encrypt(in, k, aa, ivl) : Encryption.decrypt(in, k, aa, ivl);
        }
        catch (NoSuchPaddingException e) {
            throw Err.CX_NOPAD.get(this.info, e);
        }
        catch (BadPaddingException e) {
            throw Err.CX_BADPAD.get(this.info, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw Err.CX_INVALGO.get(this.info, e);
        }
        catch (InvalidKeyException e) {
            throw Err.CX_KEYINV.get(this.info, e);
        }
        catch (IllegalBlockSizeException e) {
            throw Err.CX_ILLBLO.get(this.info, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw Err.CX_INVALGO.get(this.info, e);
        }
        return Str.get(t);
    }

    private static byte[] encrypt(byte[] in, byte[] k, byte[] a, int ivl) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(Token.string(ALGN.get(Token.lc(a))));
        SecretKeySpec kspec = new SecretKeySpec(k, Token.string(a));
        byte[] iv = new byte[ivl];
        SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
        rand.nextBytes(iv);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(1, (Key)kspec, ivspec);
        byte[] t = cipher.doFinal(in);
        return Token.concat(iv, t);
    }

    private static byte[] decrypt(byte[] in, byte[] k, byte[] a, int ivl) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec keySpec = new SecretKeySpec(k, Token.string(a));
        Cipher cipher = Cipher.getInstance(Token.string(ALGN.get(Token.lc(a))));
        byte[] iv = Token.substring(in, 0, ivl);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivspec);
        return cipher.doFinal(Token.substring(in, ivl, in.length));
    }

    public Item hmac(byte[] msg, byte[] k, byte[] a, byte[] enc) throws QueryException {
        boolean b64;
        byte[] aa;
        SecretKeySpec key = new SecretKeySpec(k, Token.string(a));
        byte[] byArray = aa = a.length == 0 ? DEFA : a;
        if (!ALGHMAC.contains(Token.lc(aa))) {
            throw Err.CX_INVHASH.get(this.info, new Object[]{aa});
        }
        boolean bl = b64 = Token.eq(Token.lc(enc), BASE64) || enc.length == 0;
        if (!b64 && !Token.eq(Token.lc(enc), HEX)) {
            throw Err.CX_ENC.get(this.info, new Object[]{enc});
        }
        try {
            Mac mac = Mac.getInstance(Token.string(ALGHMAC.get(Token.lc(aa))));
            mac.init(key);
            byte[] hash = mac.doFinal(msg);
            return Str.get(b64 ? Base64.encode(hash) : Token.hex(hash, true));
        }
        catch (NoSuchAlgorithmException e) {
            throw Err.CX_INVHASH.get(this.info, e);
        }
        catch (InvalidKeyException e) {
            throw Err.CX_KEYINV.get(this.info, e);
        }
    }

    static {
        ALGE.put("des", "8");
        ALGE.put("aes", "16");
        ALGN.put("des", "DES/CBC/PKCS5Padding");
        ALGN.put("aes", "AES/CBC/PKCS5Padding");
        ALGHMAC.put("md5", "hmacmd5");
        ALGHMAC.put("sha1", "hmacsha1");
        ALGHMAC.put("sha256", "hmacsha256");
        ALGHMAC.put("sha384", "hmacsha1");
        ALGHMAC.put("sha512", "hmacsha512");
    }
}

