/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.basex.core.MainOptions;
import org.basex.query.QueryException;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.http.HTTPPayload;
import org.basex.query.util.http.HTTPText;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class HTTPResponse {
    private final InputInfo info;
    private final MainOptions options;

    public HTTPResponse(InputInfo ii, MainOptions opts) {
        this.info = ii;
        this.options = opts;
    }

    public ValueIter getResponse(HttpURLConnection conn, byte[] status, String utype) throws IOException, QueryException {
        boolean body;
        String type = conn.getContentType();
        InputStream is = conn.getErrorStream();
        boolean error = is != null;
        try {
            if (!error) {
                is = conn.getInputStream();
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        ValueBuilder vb = new ValueBuilder();
        FElem response = new FElem(HTTPText.Q_RESPONSE).declareNS();
        response.add(HTTPText.STATUS, Token.token(conn.getResponseCode()));
        response.add(HTTPText.MESSAGE, conn.getResponseMessage());
        for (String header : conn.getHeaderFields().keySet()) {
            if (header == null) continue;
            FElem hdr = new FElem(HTTPText.Q_HEADER);
            hdr.add(HTTPText.NAME, Token.token(header));
            hdr.add(HTTPText.VALUE, conn.getHeaderField(header));
            response.add(hdr);
        }
        vb.add(response);
        boolean bl = body = status == null || !Bln.parse(status, this.info);
        if (is != null) {
            HTTPPayload hp = new HTTPPayload(is, body, this.info, this.options);
            response.add(hp.parse(error, type, utype));
            if (body) {
                vb.add(hp.payloads());
            }
        }
        return vb;
    }
}

