/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.inspect;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryProcessor;
import org.basex.query.QueryText;
import org.basex.query.StaticScope;
import org.basex.query.func.FNGen;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public abstract class Inspect {
    final QueryContext ctx;
    final InputInfo info;
    StaticScope module;

    Inspect(QueryContext qc, InputInfo ii) {
        this.ctx = qc;
        this.info = ii;
    }

    public abstract FElem parse(IO var1) throws QueryException;

    final QueryParser parseQuery(IO io) throws QueryException {
        QueryContext qc = new QueryContext(this.ctx.context);
        try {
            String input = Token.string(io.read());
            QueryParser qp = new QueryParser(input, io.path(), qc, null);
            this.module = QueryProcessor.isLibrary(input) ? qp.parseLibrary(true) : qp.parseMain();
            QueryParser queryParser = qp;
            return queryParser;
        }
        catch (IOException ex) {
            throw Err.IOERR.get(this.info, ex);
        }
        catch (QueryException ex) {
            throw Err.IOERR.get(this.info, ex);
        }
        finally {
            qc.close();
        }
    }

    final void comment(TokenObjMap<TokenList> tags, FElem parent) {
        for (byte[] key : tags) {
            for (byte[] value : tags.get(key)) {
                Inspect.add(value, this.ctx.context, this.tag(key, parent));
            }
        }
    }

    final void annotation(Ann ann, FElem parent, boolean uri) throws QueryException {
        int as = ann.size();
        for (int a = 0; a < as; ++a) {
            FElem annotation = this.elem("annotation", parent);
            annotation.add("name", ann.names[a].string());
            if (uri) {
                annotation.add("uri", ann.names[a].uri());
            }
            for (Item it : ann.values[a]) {
                FElem literal = this.elem("literal", annotation);
                literal.add("type", it.type.toString()).add(it.string(null));
            }
        }
    }

    protected abstract FElem tag(byte[] var1, FElem var2);

    protected abstract FElem elem(String var1, FElem var2);

    public static void add(byte[] value, Context ctx, FElem elem) {
        try {
            ANode node = FNGen.parseXml(new IOContent(value), ctx, true);
            for (ANode n : node.children()) {
                elem.add(n.copy());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            elem.add(value);
        }
    }

    public static byte[] doc(TokenObjMap<TokenList> doc, byte[] name) {
        TokenList params;
        TokenList tokenList = params = doc != null ? doc.get(QueryText.DOC_PARAM) : null;
        if (params != null) {
            block0: for (byte[] param : params) {
                int s;
                int vl = param.length;
                for (int v = s = Token.startsWith(param, 36) ? 1 : 0; v < vl; ++v) {
                    if (!Token.ws(param[v])) continue;
                    if (!Token.eq(Token.substring(param, s, v), name)) continue block0;
                    return Token.trim(Token.substring(param, v + 1, vl));
                }
            }
        }
        return null;
    }
}

