/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class MapType
extends FuncType {
    public final AtomType keyType;

    MapType(AtomType arg, SeqType rt) {
        super(new Ann(), new SeqType[]{arg.seqType()}, rt);
        this.keyType = arg;
    }

    @Override
    public byte[] string() {
        return QueryText.MAP;
    }

    @Override
    public Map cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        Map m;
        if (it instanceof Map && (m = (Map)it).hasType(this)) {
            return m;
        }
        throw Err.castError(ii, this, it);
    }

    @Override
    public boolean eq(Type t) {
        if (this == t) {
            return true;
        }
        if (t.getClass() != MapType.class) {
            return false;
        }
        MapType mt = (MapType)t;
        return this.keyType.eq(mt.keyType) && this.ret.eq(mt.ret);
    }

    @Override
    public boolean instanceOf(Type t) {
        if (!(t instanceof MapType)) {
            return super.instanceOf(t);
        }
        MapType mt = (MapType)t;
        return this.ret.instanceOf(mt.ret) && mt.keyType.instanceOf(this.keyType);
    }

    @Override
    public Type union(Type t) {
        if (this.instanceOf(t)) {
            return t;
        }
        if (t instanceof MapType) {
            MapType mt = (MapType)t;
            if (mt.instanceOf(this)) {
                return this;
            }
            AtomType a = (AtomType)this.keyType.intersect(mt.keyType);
            return a != null ? MapType.get(a, this.ret.union(mt.ret)) : ANY_FUN;
        }
        return t instanceof FuncType ? t.union(this) : AtomType.ITEM;
    }

    @Override
    public MapType intersect(Type t) {
        if (this.instanceOf(t)) {
            return this;
        }
        if (t instanceof MapType) {
            MapType mt = (MapType)t;
            if (mt.instanceOf(this)) {
                return mt;
            }
            SeqType rt = this.ret.intersect(mt.ret);
            return rt == null ? null : MapType.get((AtomType)this.keyType.union(mt.keyType), rt);
        }
        if (t instanceof FuncType) {
            FuncType ft = (FuncType)t;
            if (ft.args.length == 1 && ft.args[0].instanceOf(SeqType.AAT)) {
                SeqType rt = this.ret.intersect(ft.ret);
                return rt == null ? null : MapType.get((AtomType)this.keyType.union(ft.args[0].type), rt);
            }
        }
        return null;
    }

    public static MapType get(AtomType key, SeqType val) {
        return key == AtomType.AAT && val.eq(SeqType.ITEM_ZM) ? SeqType.ANY_MAP : new MapType(key, val);
    }

    @Override
    public String toString() {
        return this.keyType == AtomType.AAT && this.ret.eq(SeqType.ITEM_ZM) ? "map(*)" : "map(" + this.keyType + ", " + this.ret + ')';
    }
}

