/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import org.basex.query.QueryContext;
import org.basex.query.Scope;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Closure;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class VarScope {
    private final StaticContext sc;
    private final ArrayList<Var> vars = new ArrayList();

    public VarScope(StaticContext sctx) {
        this.sc = sctx;
    }

    private Var add(Var var) {
        var.slot = this.vars.size();
        this.vars.add(var);
        return var;
    }

    public Var newLocal(QueryContext ctx, QNm name, SeqType typ, boolean param) {
        return this.add(new Var(ctx, this.sc, name, typ, param));
    }

    public Var newCopyOf(QueryContext ctx, Var var) {
        return this.add(new Var(ctx, this.sc, var));
    }

    public int enter(QueryContext ctx) {
        return ctx.stack.enterFrame(this.vars.size());
    }

    public void exit(QueryContext ctx, int fp) {
        ctx.stack.exitFrame(fp);
    }

    public void cleanUp(Scope expr) {
        final BitSet declared = new BitSet();
        final BitSet used = new BitSet();
        expr.visit(new ASTVisitor(){

            @Override
            public boolean declared(Var var) {
                declared.set(var.id);
                return true;
            }

            @Override
            public boolean used(VarRef ref) {
                used.set(ref.var.id);
                return true;
            }
        });
        Iterator<Var> iter = this.vars.iterator();
        while (iter.hasNext()) {
            Var v = iter.next();
            if (declared.get(v.id)) continue;
            v.slot = -1;
            iter.remove();
        }
        if (expr instanceof Closure) {
            Iterator<Map.Entry<Var, Expr>> cls = ((Closure)expr).nonLocalBindings();
            while (cls.hasNext()) {
                Map.Entry<Var, Expr> e = cls.next();
                Var v = e.getKey();
                if (used.get(v.id)) continue;
                cls.remove();
                v.slot = -1;
                this.vars.remove(v);
            }
        }
        int i = this.vars.size();
        while (--i >= 0) {
            this.vars.get((int)i).slot = i;
        }
    }

    public String toString() {
        return Util.className(this) + this.vars.toString();
    }

    public int stackSize() {
        return this.vars.size();
    }

    public VarScope copy(QueryContext ctx, IntObjMap<Var> vs) {
        VarScope cscp = new VarScope(this.sc);
        for (Var v : this.vars) {
            vs.put(v.id, cscp.newCopyOf(ctx, v));
        }
        return cscp;
    }
}

