/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.io.IOFile;
import org.basex.util.DateTime;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Log {
    public static final String SERVER = "SERVER";
    public static final String ERROR = "ERROR";
    public static final String REQUEST = "REQUEST";
    private final GlobalOptions gopts;
    private String start;
    private FileOutputStream fos;

    public Log(Context ctx) {
        this.gopts = ctx.globalopts;
    }

    public synchronized void writeError(Throwable th) {
        this.writeServer(ERROR, Util.message(th));
    }

    public synchronized void writeServer(Object ... str) {
        Object[] tmp = new Object[str.length + 2];
        tmp[0] = SERVER;
        tmp[1] = "admin";
        System.arraycopy(str, 0, tmp, 2, str.length);
        this.write(tmp);
    }

    public synchronized void write(Object ... str) {
        if (!this.gopts.get(GlobalOptions.LOG).booleanValue()) {
            this.close();
            return;
        }
        Date date = new Date();
        try {
            String nstart = DateTime.format(date, DateTime.DATE);
            if (this.fos != null && !this.start.equals(nstart)) {
                this.close();
            }
            if (this.fos == null) {
                IOFile dir = this.dir();
                dir.md();
                this.fos = new FileOutputStream(new IOFile(dir, nstart + ".log").file(), true);
                this.start = nstart;
            }
            int ml = this.gopts.get(GlobalOptions.LOGMSGMAXLEN);
            TokenBuilder tb = new TokenBuilder(DateTime.format(date, DateTime.TIME));
            for (Object s : str) {
                tb.add(9);
                String st = s == null ? REQUEST : (s instanceof Boolean ? ((Boolean)s != false ? "OK" : ERROR) : (s instanceof Throwable ? Util.message((Throwable)s) : s.toString()));
                tb.add(Token.chop(Token.token(st.replaceAll("\\s+", " ").trim()), ml));
            }
            tb.add(Prop.NL);
            this.fos.write(tb.finish());
            this.fos.flush();
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized void close() {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
            this.fos = null;
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized IOFile dir() {
        return this.gopts.dbpath(".logs");
    }

    public synchronized IOFile[] files() {
        return this.dir().children(".*\\.log");
    }

    public static class LogEntry {
        public String time;
        public String address;
        public String user;
        public String type;
        public BigDecimal ms;
        public String message;
    }
}

