/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;
import org.basex.util.list.IntList;

public class TokenParser {
    protected final byte[] token;
    private final int size;
    private int pos;

    public TokenParser(byte[] tok) {
        this.token = tok;
        this.size = this.token.length;
    }

    public void reset() {
        this.pos = 0;
    }

    public boolean more() {
        return this.pos < this.size;
    }

    public int next() {
        int p = this.pos;
        if (p < this.size) {
            this.pos += Token.cl(this.token, p);
            return Token.cp(this.token, p);
        }
        return -1;
    }

    public boolean consume(int ch) {
        int p = this.pos;
        if (p >= this.size || Token.cp(this.token, p) != ch) {
            return false;
        }
        this.pos += Token.cl(this.token, p);
        return true;
    }

    public final IntList toList() {
        IntList il = new IntList();
        while (this.more()) {
            il.add(this.next());
        }
        return il;
    }

    public String toString() {
        return Token.string(this.token);
    }
}

