/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntSet;

public final class IntObjMap<E>
extends IntSet {
    private Object[] values = new Object[8];

    public void put(int key, E value) {
        int i = this.put(key);
        this.values[i] = value;
    }

    public E get(int key) {
        return (E)this.values[this.id(key)];
    }

    public Iterable<E> values() {
        return new ArrayIterator(this.values, 1, this.size);
    }

    @Override
    protected void rehash(int s) {
        super.rehash(s);
        this.values = Array.copy(this.values, new Object[s]);
    }

    @Override
    public int delete(int key) {
        int i = super.delete(key);
        if (i != 0) {
            this.values[i] = null;
        }
        return i;
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(Util.className(this)).add(91);
        for (int i = 1; i < this.size; ++i) {
            tb.add(Integer.toString(this.keys[i])).add(": ").add(this.get(this.keys[i]).toString());
            if (i >= this.size - 1) continue;
            tb.add(",\n\t");
        }
        return tb.add(93).toString();
    }
}

