/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Token;
import org.basex.util.list.ElementList;

public class ByteList
extends ElementList {
    protected byte[] list;

    public ByteList() {
        this(8);
    }

    public ByteList(int capacity) {
        this.list = new byte[capacity];
    }

    public ByteList add(int element) {
        if (this.size == this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = (byte)element;
        return this;
    }

    public ByteList add(byte[] elements) {
        return this.add(elements, 0, elements.length);
    }

    public ByteList add(byte[] elements, int start, int end) {
        int l = end - start;
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(this.size + l));
        }
        System.arraycopy(elements, start, this.list, this.size, l);
        this.size += l;
        return this;
    }

    public final byte get(int index) {
        return this.list[index];
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public String toString() {
        return Token.string(this.list, 0, this.size);
    }
}

