/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.options;

import org.basex.util.options.Option;

public final class EnumOption<V extends Enum<V>>
extends Option<V> {
    private final Class<V> clazz;
    private final V value;

    public EnumOption(String n, V v) {
        super(n);
        this.value = v;
        this.clazz = v.getClass();
    }

    public EnumOption(String n, Class<V> v) {
        super(n);
        this.clazz = v;
        this.value = null;
    }

    @Override
    public V value() {
        return this.value;
    }

    public V get(String string) {
        for (Enum v : this.values()) {
            if (!v.toString().equals(string)) continue;
            return (V)v;
        }
        return null;
    }

    public V[] values() {
        return (Enum[])this.clazz.getEnumConstants();
    }
}

