/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbilcommons.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import nl.mpi.arbilcommons.ui.LocaleOption;
import nl.mpi.flap.plugin.PluginSessionStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalisationSelector {
    private static final String SELECTED_LOCALE_KEY = "selectedLocale";
    private static final String SYSTEM_DEFAULT = "<system default>";
    private final PluginSessionStorage sessionStorage;
    private final List<Locale> knownLocales;

    public LocalisationSelector(PluginSessionStorage sessionStorage, String[] availableLocales) {
        this.sessionStorage = sessionStorage;
        this.knownLocales = new ArrayList<Locale>();
        for (String locale : availableLocales) {
            this.knownLocales.add(LocalisationSelector.createLocale(locale));
        }
    }

    public LocalisationSelector(PluginSessionStorage sessionStorage, List<Locale> knownLocales) {
        this.sessionStorage = sessionStorage;
        this.knownLocales = knownLocales;
    }

    private Locale getSavedLocale() {
        String selectedLocaleString = this.sessionStorage.loadString(SELECTED_LOCALE_KEY);
        if (selectedLocaleString == null || selectedLocaleString.equals(SYSTEM_DEFAULT)) {
            return null;
        }
        return LocalisationSelector.createLocale(selectedLocaleString);
    }

    private void setSavedLocale(Locale locale) {
        if (locale == null) {
            this.sessionStorage.saveString(SELECTED_LOCALE_KEY, SYSTEM_DEFAULT);
        } else {
            this.sessionStorage.saveString(SELECTED_LOCALE_KEY, locale.toString());
        }
    }

    public boolean askUser(JFrame jFrame, Icon icon, String please_select_your_preferred_language, String language_Selection, String system_Default) {
        Object[] possibilities = new LocaleOption[this.knownLocales.size() + 1];
        possibilities[0] = new LocaleOption(system_Default);
        int localeIndex = 1;
        for (Locale locale : this.knownLocales) {
            possibilities[localeIndex] = new LocaleOption(locale);
            ++localeIndex;
        }
        Locale savedLocale = this.getSavedLocale();
        LocaleOption defaultValue = savedLocale == null ? new LocaleOption(system_Default) : new LocaleOption(savedLocale);
        LocaleOption userSelection = (LocaleOption)JOptionPane.showInputDialog(jFrame, please_select_your_preferred_language, language_Selection, -1, icon, possibilities, defaultValue);
        if (userSelection != null) {
            if (userSelection.getLocale() == null) {
                boolean modified = this.getSavedLocale() != null;
                this.setSavedLocale(null);
                return modified;
            }
            this.setSavedLocale(userSelection.getLocale());
            return !userSelection.getLocale().equals(savedLocale);
        }
        return false;
    }

    public boolean hasSavedLocal() {
        String selectedLocaleString = this.sessionStorage.loadString(SELECTED_LOCALE_KEY);
        return selectedLocaleString != null && selectedLocaleString.length() > 0;
    }

    public void setLanguageFromSaved() {
        Locale savedLocale = this.getSavedLocale();
        if (savedLocale != null) {
            Locale.setDefault(savedLocale);
        }
    }

    private static Locale createLocale(String localeString) {
        if (localeString.contains("_")) {
            String[] localeTokens = localeString.split("_");
            return new Locale(localeTokens[0], localeTokens[1]);
        }
        return new Locale(localeString);
    }
}

