/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.TimerTask;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.Main;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.server.ClientListener;
import org.basex.server.ClientSession;
import org.basex.server.LocalSession;
import org.basex.server.LoginException;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class BaseXServer
extends Main
implements Runnable {
    private volatile boolean running;
    private ServerSocket esocket;
    private IOFile stop;
    private final HashSet<ClientListener> auth = new HashSet();
    private volatile boolean stopped;
    private EventListener events;
    private StringList commands;
    private ServerSocket socket;
    private boolean service;

    public static void main(String[] args) {
        try {
            new BaseXServer(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXServer(String ... args) throws IOException {
        this((Context)null, args);
    }

    public BaseXServer(Context ctx, String ... args) throws IOException {
        super(args, ctx);
        InetAddress addr;
        GlobalOptions gopts = this.context.globalopts;
        final int port = gopts.get(GlobalOptions.SERVERPORT);
        int eport = gopts.get(GlobalOptions.EVENTPORT);
        if (port == eport) {
            throw new BaseXException(Text.PORT_TWICE_X, port);
        }
        String host = gopts.get(GlobalOptions.SERVERHOST);
        InetAddress inetAddress = addr = host.isEmpty() ? null : InetAddress.getByName(host);
        if (this.service) {
            BaseXServer.start(port, args);
            Util.outln(Text.SRV_STARTED_PORT_X, port);
            Performance.sleep(1000L);
            return;
        }
        if (this.stopped) {
            BaseXServer.stop(port, eport);
            Util.outln(Text.SRV_STOPPED_PORT_X, port);
            Performance.sleep(1000L);
            return;
        }
        try {
            for (String c : this.commands) {
                this.execute(c);
            }
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, port));
            this.esocket = new ServerSocket();
            this.esocket.setReuseAddress(true);
            this.esocket.bind(new InetSocketAddress(addr, eport));
            this.stop = BaseXServer.stopFile(port);
            this.context.log.writeServer("OK", Util.info(Text.SRV_STARTED_PORT_X, port));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    BaseXServer.this.context.log.writeServer("OK", Util.info(Text.SRV_STOPPED_PORT_X, port));
                    Util.outln(Text.SRV_STOPPED_PORT_X, port);
                }
            });
            new Thread(this).start();
            while (!this.running) {
                Performance.sleep(10L);
            }
            Util.outln(Text.S_CONSOLE + (this.console ? Text.TRY_MORE_X : Util.info(Text.SRV_STARTED_PORT_X, port)), "Server");
            if (this.console) {
                this.console();
                this.quit();
            }
        }
        catch (IOException ex) {
            this.context.log.writeError(ex);
            throw ex;
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.socket.accept();
                if (this.stop.exists()) {
                    if (!this.stop.delete()) {
                        this.context.log.writeServer(Text.ERROR + ":" + Util.info(Text.FILE_NOT_DELETED_X, this.stop));
                    }
                    this.quit();
                    continue;
                }
                long ka = (long)this.context.globalopts.get(GlobalOptions.KEEPALIVE).intValue() * 1000L;
                if (ka > 0L) {
                    long ms = System.currentTimeMillis();
                    for (ClientListener cs : this.context.sessions) {
                        if (ms - cs.last <= ka) continue;
                        cs.quit();
                    }
                }
                final ClientListener cl = new ClientListener(s, this.context, this);
                long to = (long)this.context.globalopts.get(GlobalOptions.KEEPALIVE).intValue() * 1000L;
                if (to > 0L) {
                    cl.auth.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            cl.quitAuth();
                        }
                    }, to);
                    this.auth.add(cl);
                }
                cl.start();
            }
            catch (SocketException ex) {
                break;
            }
            catch (Throwable ex) {
                Util.errln(ex, new Object[0]);
                this.context.log.writeError(ex);
                break;
            }
        }
    }

    private static IOFile stopFile(int port) {
        return new IOFile(Prop.TMP, Util.className(BaseXServer.class) + port);
    }

    @Override
    protected synchronized void quit() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        for (ClientListener cs : this.auth) {
            this.remove(cs);
            cs.quitAuth();
        }
        for (ClientListener cs : this.context.sessions) {
            cs.quit();
        }
        super.quit();
        try {
            if (this.console) {
                System.in.close();
            }
            this.esocket.close();
            this.socket.close();
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            this.context.log.writeError(ex);
        }
        this.console = false;
    }

    @Override
    protected Session session() {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        return this.session;
    }

    @Override
    protected void parseArguments(String ... args) throws IOException {
        Args arg = new Args(args, this, Text.S_SERVERINFO, Util.info(Text.S_CONSOLE, "Server"));
        this.commands = new StringList();
        boolean daemon = false;
        block11: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(arg.string());
                        continue block11;
                    }
                    case 'd': {
                        Prop.debug = true;
                        continue block11;
                    }
                    case 'D': {
                        daemon = true;
                        continue block11;
                    }
                    case 'e': {
                        this.context.globalopts.set(GlobalOptions.EVENTPORT, arg.number());
                        continue block11;
                    }
                    case 'i': {
                        this.console = true;
                        continue block11;
                    }
                    case 'n': {
                        this.context.globalopts.set(GlobalOptions.SERVERHOST, arg.string());
                        continue block11;
                    }
                    case 'p': {
                        this.context.globalopts.set(GlobalOptions.SERVERPORT, arg.number());
                        continue block11;
                    }
                    case 'S': {
                        this.service = !daemon;
                        continue block11;
                    }
                    case 'z': {
                        this.context.globalopts.set(GlobalOptions.LOG, false);
                        continue block11;
                    }
                }
                throw arg.usage();
            }
            if ("stop".equalsIgnoreCase(arg.string())) {
                this.stopped = true;
                continue;
            }
            throw arg.usage();
        }
    }

    public void stop() throws IOException {
        GlobalOptions gopts = this.context.globalopts;
        BaseXServer.stop(gopts.get(GlobalOptions.SERVERPORT), gopts.get(GlobalOptions.EVENTPORT));
    }

    public static void start(int port, String ... args) throws BaseXException {
        if (BaseXServer.ping("localhost", port)) {
            throw new BaseXException(Text.SRV_RUNNING, new Object[0]);
        }
        Util.start(BaseXServer.class, args);
        for (int c = 1; c < 10; ++c) {
            if (BaseXServer.ping("localhost", port)) {
                return;
            }
            Performance.sleep(c * 100);
        }
        throw new BaseXException(Text.CONNECTION_ERROR, new Object[0]);
    }

    public static boolean ping(String host, int port) {
        try {
            new ClientSession(host, port, "", "");
            return false;
        }
        catch (LoginException ex) {
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void stop(int port, int eport) throws IOException {
        IOFile stop = BaseXServer.stopFile(port);
        try {
            stop.touch();
            new Socket("localhost", eport).close();
            new Socket("localhost", port).close();
            do {
                Performance.sleep(50L);
            } while (BaseXServer.ping("localhost", port));
        }
        catch (IOException ex) {
            stop.delete();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ClientListener client) {
        HashSet<ClientListener> hashSet = this.auth;
        synchronized (hashSet) {
            this.auth.remove(client);
            client.auth.cancel();
        }
    }

    public void initEvents() {
        if (this.events == null) {
            this.events = new EventListener();
            this.events.start();
        }
    }

    private final class EventListener
    extends Thread {
        private EventListener() {
        }

        @Override
        public void run() {
            block2: while (BaseXServer.this.running) {
                try {
                    Socket es = BaseXServer.this.esocket.accept();
                    if (BaseXServer.this.stop.exists()) {
                        BaseXServer.this.esocket.close();
                        break;
                    }
                    BufferInput bi = new BufferInput(es.getInputStream());
                    long id = Token.toLong(bi.readString());
                    for (ClientListener s : BaseXServer.this.context.sessions) {
                        if (s.getId() != id) continue;
                        s.register(es);
                        continue block2;
                    }
                }
                catch (IOException ex) {
                    break;
                }
            }
        }
    }
}

