/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Proc;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.parse.CmdBuilder;
import org.basex.data.Data;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public abstract class Command
extends Proc {
    public final String[] args;
    public final Perm perm;
    public final boolean openDB;
    public Exception cause;
    protected Performance perf;
    protected Context context;
    protected PrintOutput out;
    protected InputSource in;
    protected MainOptions options;
    protected GlobalOptions goptions;
    private final TokenBuilder info = new TokenBuilder();

    protected Command(Perm p, String ... arg) {
        this(p, false, arg);
    }

    protected Command(Perm p, boolean d, String ... arg) {
        this.perm = p;
        this.openDB = d;
        this.args = arg;
    }

    public final void execute(Context ctx, OutputStream os) throws BaseXException {
        Data dt = ctx.data();
        if (dt == null && this.openDB) {
            throw new BaseXException(Text.NO_DB_OPENED, new Object[0]);
        }
        if (!ctx.perm(this.perm, dt != null ? dt.meta : null)) {
            throw new BaseXException(Text.PERM_REQUIRED_X, new Object[]{this.perm});
        }
        this.updating = this.updating(ctx);
        try {
            ctx.register(this);
            if (!this.run(ctx, os)) {
                BaseXException ex = new BaseXException(this.info(), new Object[0]);
                ex.initCause(this.cause);
                throw ex;
            }
        }
        catch (RuntimeException th) {
            Util.stack(th);
            throw th;
        }
        finally {
            ctx.unregister(this);
        }
    }

    public final String execute(Context ctx) throws BaseXException {
        ArrayOutput ao = new ArrayOutput();
        this.execute(ctx, ao);
        return ao.toString();
    }

    public void setInput(InputStream is) {
        this.in = new InputSource(is);
    }

    public void setInput(InputSource is) {
        this.in = is;
    }

    public final boolean run(Context ctx) {
        return this.run(ctx, new NullOutput());
    }

    public final String info() {
        return this.info.toString();
    }

    public Result result() {
        return null;
    }

    public boolean updating(Context ctx) {
        return this.perm == Perm.CREATE || this.perm == Perm.WRITE;
    }

    public boolean updated(Context ctx) {
        return this.updating(ctx);
    }

    public boolean newData(Context ctx) {
        return false;
    }

    public boolean supportsProg() {
        return false;
    }

    public boolean stoppable() {
        return false;
    }

    public final String toString() {
        CmdBuilder cb = new CmdBuilder(this);
        this.build(cb);
        return cb.toString();
    }

    protected abstract boolean run() throws IOException;

    protected void build(CmdBuilder cb) {
        cb.init().args();
    }

    protected final boolean error(String msg, Object ... ext) {
        this.info.reset();
        this.info.addExt(msg == null ? "" : msg, ext);
        return false;
    }

    protected final boolean info(String str, Object ... ext) {
        if (!str.isEmpty()) {
            this.info.addExt(str, ext).add(Text.NL);
        }
        return true;
    }

    protected final <E extends Enum<E>> E getOption(Class<E> typ) {
        E e = Command.getOption(this.args[0], typ);
        if (e == null) {
            this.error(Text.UNKNOWN_TRY_X, this.args[0]);
        }
        return e;
    }

    protected final boolean databases(StringList db, int a) {
        boolean noglob;
        if (this.args.length <= a || this.args[a] == null) {
            return true;
        }
        boolean bl = noglob = !this.args[a].matches(".*[\\?\\*,].*");
        if (noglob) {
            db.add(this.args[a]);
        }
        return noglob;
    }

    protected static <E extends Enum<E>> E getOption(String s, Class<E> typ) {
        try {
            return Enum.valueOf(typ, s.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static boolean close(Context ctx, String db) {
        boolean close = ctx.data() != null && db.equals(ctx.data().meta.name) && ctx.dbs.pins(db) == 1;
        return close && new Close().run(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(Context ctx, OutputStream os) {
        this.perf = new Performance();
        this.context = ctx;
        this.options = ctx.options;
        this.goptions = ctx.globalopts;
        this.out = PrintOutput.get(os);
        try {
            boolean bl = this.run();
            return bl;
        }
        catch (ProcException ex) {
            this.abort();
            boolean bl = this.error(Text.INTERRUPTED, new Object[0]);
            return bl;
        }
        catch (Throwable ex) {
            block21: {
                Performance.gc(2);
                this.abort();
                if (!(ex instanceof OutOfMemoryError)) break block21;
                Util.debug(ex);
                boolean bl = this.error(Text.OUT_OF_MEM + (this.perm == Perm.CREATE ? Text.H_OUT_OF_MEM : ""), new Object[0]);
                try {
                    if (this.out != null) {
                        this.out.flush();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return bl;
            }
            boolean bl = this.error(Util.bug(ex) + Text.NL + this.info.toString(), new Object[0]);
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return bl;
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException ignored) {}
        }
    }
}

