/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.regex.Pattern;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.GlobalOptions;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.DropDB;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Copy
extends Command {
    private static final Pattern FILES = Pattern.compile(".{3,5}.basex");
    private int of;
    private int tf;

    public Copy(String db, String newdb) {
        super(Perm.CREATE, db, newdb);
    }

    @Override
    protected boolean run() {
        String src = this.args[0];
        String trg = this.args[1];
        if (!Databases.validName(src)) {
            return this.error(Text.NAME_INVALID_X, src);
        }
        if (!Databases.validName(trg)) {
            return this.error(Text.NAME_INVALID_X, trg);
        }
        if (!this.goptions.dbexists(src)) {
            return this.error(Text.DB_NOT_FOUND_X, src);
        }
        if (this.goptions.dbexists(trg)) {
            return this.error(Text.DB_EXISTS_X, trg);
        }
        try {
            Copy.copy(src, trg, this.context, this);
            return this.info(Text.DB_COPIED_X, src, this.perf);
        }
        catch (IOException ex) {
            return this.error(Text.DB_NOT_COPIED_X, src);
        }
    }

    public static void copy(String source, String target, Context context, Copy cmd) throws IOException {
        GlobalOptions goptions = context.globalopts;
        IOFile src = goptions.dbpath(source);
        IOFile trg = goptions.dbpath(target);
        DropDB.drop(target, context);
        StringList files = src.descendants();
        if (cmd != null) {
            cmd.tf = files.size();
        }
        try {
            for (String file : files) {
                if (FILES.matcher(file).matches()) {
                    new IOFile(src, file).copyTo(new IOFile(trg, file));
                }
                if (cmd == null) continue;
                ++cmd.of;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            DropDB.drop(target, context);
            throw ex;
        }
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add(this.args[0]);
        lr.write.add(this.args[1]);
    }

    @Override
    protected String tit() {
        return Text.COPY;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    protected double prog() {
        return (double)this.of / (double)this.tf;
    }
}

