/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.util.ArrayList;
import java.util.Collections;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.CommandParser;
import org.basex.query.QueryException;
import org.basex.util.Util;

public class Execute
extends Command {
    final ArrayList<Command> list = new ArrayList();
    String error;

    public Execute(String input) {
        super(Perm.ADMIN, false, input);
    }

    @Override
    public boolean newData(Context ctx) {
        return new Close().run(ctx);
    }

    @Override
    public void databases(LockResult lr) {
        lr.writeAll = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        try {
            if (!this.init(this.context)) {
                boolean bl = this.error(this.error, new Object[0]);
                return bl;
            }
            StringBuilder sb = new StringBuilder();
            for (Command c : this.list) {
                if (c.openDB && this.context.data() == null) {
                    boolean bl = this.error(Text.NO_DB_OPENED, new Object[0]);
                    return bl;
                }
                boolean ok = this.proc(c).run(this.context, this.out);
                this.proc(null);
                sb.append(c.info());
                if (ok) continue;
                this.cause = c.cause;
                boolean bl = this.error(sb.toString(), new Object[0]);
                return bl;
            }
            boolean bl = this.info(sb.toString().replaceAll("\r?\n?$", ""), new Object[0]);
            return bl;
        }
        finally {
            this.finish(this.context);
        }
    }

    @Override
    public boolean updating(Context ctx) {
        if (!this.init(ctx)) {
            return true;
        }
        for (Command c : this.list) {
            if (c.updating(ctx)) continue;
            return true;
        }
        return false;
    }

    boolean init(Context ctx) {
        return this.init(this.args[0], ctx);
    }

    final boolean init(String input, Context ctx) {
        if (this.list.isEmpty() && this.error == null) {
            try {
                Collections.addAll(this.list, new CommandParser(input, ctx).parse());
            }
            catch (QueryException ex) {
                this.error = Util.message(ex);
                return false;
            }
        }
        return this.error == null;
    }

    void finish(Context ctx) {
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg(0);
    }
}

