/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateEvent;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.DropEvent;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Execute;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.Help;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.InfoStorage;
import org.basex.core.cmd.Inspect;
import org.basex.core.cmd.Kill;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.core.cmd.RepoList;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.Retrieve;
import org.basex.core.cmd.Run;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.ShowBackups;
import org.basex.core.cmd.ShowEvents;
import org.basex.core.cmd.ShowSessions;
import org.basex.core.cmd.ShowUsers;
import org.basex.core.cmd.Store;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CmdParser;
import org.basex.core.parse.Commands;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.value.item.QNm;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class StringParser
extends CmdParser {
    private InputParser parser;

    public StringParser(String input, Context context) {
        super(input, context);
    }

    @Override
    protected void parse(ArrayList<Command> cmds) throws QueryException {
        Scanner sc = new Scanner(this.input).useDelimiter(this.single ? "\u0000" : "\r\n?|\n");
        while (sc.hasNext()) {
            String line = sc.next().trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            this.parser = new InputParser(line);
            this.parser.file = this.ctx.options.get(MainOptions.QUERYPATH);
            while (this.parser.more()) {
                Commands.Cmd cmd = this.consume(Commands.Cmd.class, null);
                if (cmd != null) {
                    cmds.add(this.parse(cmd));
                }
                if (!this.parser.more() || this.parser.consume(59)) continue;
                throw this.help(null, cmd);
            }
        }
    }

    private Command parse(Commands.Cmd cmd) throws QueryException {
        switch (cmd) {
            case CREATE: {
                switch (this.consume(Commands.CmdCreate.class, cmd)) {
                    case BACKUP: {
                        return new CreateBackup(this.glob(cmd));
                    }
                    case DATABASE: 
                    case DB: {
                        return new CreateDB(this.name(cmd), this.remaining(null));
                    }
                    case INDEX: {
                        return new CreateIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new CreateUser(this.name(cmd), this.password());
                    }
                    case EVENT: {
                        return new CreateEvent(this.name(cmd));
                    }
                }
                break;
            }
            case COPY: {
                return new Copy(this.name(cmd), this.name(cmd));
            }
            case ALTER: {
                switch (this.consume(Commands.CmdAlter.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new AlterDB(this.name(cmd), this.name(cmd));
                    }
                    case USER: {
                        return new AlterUser(this.name(cmd), this.password());
                    }
                }
                break;
            }
            case OPEN: {
                return new Open(this.name(cmd));
            }
            case CHECK: {
                return new Check(this.string(cmd));
            }
            case ADD: {
                String arg = this.key("TO", null) ? this.string(cmd) : null;
                return new Add(arg, this.remaining(cmd));
            }
            case STORE: {
                String arg = this.key("TO", null) ? this.string(cmd) : null;
                return new Store(arg, this.remaining(cmd));
            }
            case RETRIEVE: {
                return new Retrieve(this.string(cmd));
            }
            case DELETE: {
                return new Delete(this.string(cmd));
            }
            case RENAME: {
                return new Rename(this.string(cmd), this.string(cmd));
            }
            case REPLACE: {
                return new Replace(this.string(cmd), this.remaining(cmd));
            }
            case INFO: {
                switch (this.consume(Commands.CmdInfo.class, cmd)) {
                    case NULL: {
                        return new Info();
                    }
                    case DATABASE: 
                    case DB: {
                        return new InfoDB();
                    }
                    case INDEX: {
                        return new InfoIndex((Object)this.consume(Commands.CmdIndexInfo.class, null));
                    }
                    case STORAGE: {
                        String arg2;
                        String arg1 = this.number(null);
                        String string = arg2 = arg1 != null ? this.number(null) : null;
                        if (arg1 == null) {
                            arg1 = this.xquery(null);
                        }
                        return new InfoStorage(arg1, arg2);
                    }
                }
                break;
            }
            case INSPECT: {
                return new Inspect();
            }
            case CLOSE: {
                return new Close();
            }
            case LIST: {
                return new List(this.name(null), this.string(null));
            }
            case DROP: {
                switch (this.consume(Commands.CmdDrop.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new DropDB(this.glob(cmd));
                    }
                    case INDEX: {
                        return new DropIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new DropUser(this.glob(cmd), this.key("ON", null) ? this.glob(cmd) : null);
                    }
                    case BACKUP: {
                        return new DropBackup(this.glob(cmd));
                    }
                    case EVENT: {
                        return new DropEvent(this.name(cmd));
                    }
                }
                break;
            }
            case OPTIMIZE: {
                switch (this.consume(Commands.CmdOptimize.class, cmd)) {
                    case NULL: {
                        return new Optimize();
                    }
                    case ALL: {
                        return new OptimizeAll();
                    }
                }
                break;
            }
            case EXPORT: {
                return new Export(this.string(cmd));
            }
            case XQUERY: {
                return new XQuery(this.xquery(cmd));
            }
            case RUN: {
                return new Run(this.string(cmd));
            }
            case EXECUTE: {
                return new Execute(this.string(cmd, false));
            }
            case FIND: {
                return new Find(this.string(cmd, false));
            }
            case CS: {
                return new Cs(this.xquery(cmd));
            }
            case GET: {
                return new Get(this.name(null));
            }
            case SET: {
                return new Set(this.name(cmd), (Object)this.string(null, false));
            }
            case PASSWORD: {
                return new Password(this.password());
            }
            case HELP: {
                return new Help(this.name(null));
            }
            case EXIT: {
                return new Exit();
            }
            case FLUSH: {
                return new Flush();
            }
            case KILL: {
                return new Kill(this.string(cmd));
            }
            case RESTORE: {
                return new Restore(this.name(cmd));
            }
            case SHOW: {
                switch (this.consume(Commands.CmdShow.class, cmd)) {
                    case SESSIONS: {
                        return new ShowSessions();
                    }
                    case USERS: {
                        return new ShowUsers(this.key("ON", null) ? this.name(cmd) : null);
                    }
                    case BACKUPS: {
                        return new ShowBackups();
                    }
                    case EVENTS: {
                        return new ShowEvents();
                    }
                }
                break;
            }
            case GRANT: {
                Commands.CmdPerm perm = this.consume(Commands.CmdPerm.class, cmd);
                if (perm == null) {
                    throw this.help(null, cmd);
                }
                String db = this.key("ON", null) ? this.glob(cmd) : null;
                this.key("TO", cmd);
                return new Grant((Object)perm, this.glob(cmd), db);
            }
            case REPO: {
                switch (this.consume(Commands.CmdRepo.class, cmd)) {
                    case INSTALL: {
                        return new RepoInstall(this.string(cmd), new InputInfo(this.parser));
                    }
                    case DELETE: {
                        return new RepoDelete(this.string(cmd), new InputInfo(this.parser));
                    }
                    case LIST: {
                        return new RepoList();
                    }
                }
            }
        }
        throw Util.notExpected("command specified, but not implemented yet");
    }

    private String string(Commands.Cmd cmd) throws QueryException {
        return this.string(cmd, true);
    }

    private String string(Commands.Cmd cmd, boolean space) throws QueryException {
        StringBuilder sb = new StringBuilder();
        this.consumeWS();
        boolean q = false;
        while (this.parser.more()) {
            char c = this.parser.curr();
            if (!q && ((!space ? c < ' ' : c <= ' ') || this.eoc())) break;
            if (c == '\"') {
                q ^= true;
            } else {
                sb.append(c);
            }
            this.parser.consume();
        }
        return this.finish(sb, cmd);
    }

    private String remaining(Commands.Cmd cmd) throws QueryException {
        if (this.single) {
            StringBuilder sb = new StringBuilder();
            this.consumeWS();
            while (this.parser.more()) {
                sb.append(this.parser.consume());
            }
            String arg = this.finish(sb, cmd);
            if (arg != null) {
                if (arg.startsWith("\"")) {
                    arg = arg.substring(1);
                }
                if (arg.endsWith("\"")) {
                    arg = arg.substring(0, arg.length() - 1);
                }
            }
            return arg;
        }
        return this.string(cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String xquery(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (!this.eoc()) {
            QueryContext qc = new QueryContext(this.ctx);
            try {
                QueryParser p = new QueryParser(this.parser.input, null, qc, null);
                p.pos = this.parser.pos;
                p.parseMain();
                sb.append(this.parser.input.substring(this.parser.pos, p.pos));
                this.parser.pos = p.pos;
            }
            finally {
                qc.close();
            }
        }
        return this.finish(sb, cmd);
    }

    private String command(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        while (!this.eoc() && !Token.ws(this.parser.curr())) {
            sb.append(this.parser.consume());
        }
        return this.finish(sb, cmd);
    }

    private String name(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        while (Databases.validChar(this.parser.curr())) {
            sb.append(this.parser.consume());
        }
        return this.finish(this.eoc() || Token.ws(this.parser.curr()) ? sb : null, cmd);
    }

    private String password() throws QueryException {
        String pw = this.string(null);
        return pw != null ? pw : (this.pwReader == null ? "" : this.pwReader.password());
    }

    private String glob(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        char ch;
        while (Databases.validChar(ch = this.parser.curr()) || ch == '*' || ch == '?' || ch == ',') {
            sb.append(this.parser.consume());
        }
        return this.finish(this.eoc() || Token.ws(ch) ? sb : null, cmd);
    }

    private boolean key(String key, Commands.Cmd cmd) throws QueryException {
        boolean ok;
        this.consumeWS();
        int p = this.parser.pos;
        boolean bl = ok = !(!this.parser.consume(key) && !this.parser.consume(key.toLowerCase(Locale.ENGLISH)) || !this.parser.curr(0) && !Token.ws(this.parser.curr()));
        if (!ok) {
            this.parser.pos = p;
            if (cmd != null) {
                throw this.help(null, cmd);
            }
        }
        return ok;
    }

    private String finish(StringBuilder s, Commands.Cmd cmd) throws QueryException {
        if (s != null && s.length() != 0) {
            return s.toString();
        }
        if (cmd != null) {
            throw this.help(null, cmd);
        }
        return null;
    }

    private String number(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (this.parser.curr() == '-') {
            sb.append(this.parser.consume());
        }
        while (Token.digit(this.parser.curr())) {
            sb.append(this.parser.consume());
        }
        return this.finish(this.eoc() || Token.ws(this.parser.curr()) ? sb : null, cmd);
    }

    private void consumeWS() {
        while (this.parser.pos < this.parser.length && this.parser.input.charAt(this.parser.pos) <= ' ') {
            ++this.parser.pos;
        }
        this.parser.mark = this.parser.pos - 1;
    }

    private <E extends Enum<E>> E consume(Class<E> cmp, Commands.Cmd par) throws QueryException {
        String token = this.command(null);
        if (!this.suggest || token == null || !token.isEmpty()) {
            try {
                return Enum.valueOf(cmp, token == null ? "NULL" : token.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ignore) {
                // empty catch block
            }
        }
        Enum<?>[] alt = StringParser.startWith(cmp, token);
        if (token == null) {
            if (par != null) {
                throw this.help(alt, par);
            }
            if (this.suggest) {
                throw this.error(alt, Text.EXPECTING_CMD, new Object[0]);
            }
            return null;
        }
        byte[] name = Token.uc(Token.token(token));
        Levenshtein ls = new Levenshtein();
        for (Enum<?> s : StringParser.startWith(cmp, null)) {
            byte[] sm = Token.uc(Token.token(s.name()));
            if (!ls.similar(name, sm) || !Commands.Cmd.class.isInstance(s)) continue;
            throw this.error(alt, Text.UNKNOWN_SIMILAR_X, name, sm);
        }
        throw par == null ? this.error(alt, Text.UNKNOWN_TRY_X, token) : this.help(alt, par);
    }

    private QueryException help(Enum<?>[] alt, Commands.Cmd cmd) {
        return this.error(alt, Text.SYNTAX_X, cmd.help(true));
    }

    private static <T extends Enum<T>> Enum<?>[] startWith(Class<T> en, String prefix) {
        Enum[] list = new Enum[]{};
        String t = prefix == null ? "" : prefix.toUpperCase(Locale.ENGLISH);
        for (Enum e : (Enum[])en.getEnumConstants()) {
            if (!e.name().startsWith(t)) continue;
            int s = list.length;
            list = Array.copy(list, new Enum[s + 1]);
            list[s] = e;
        }
        return list;
    }

    private boolean eoc() {
        return !this.parser.more() || this.parser.curr() == ';';
    }

    private QueryException error(Enum<?>[] comp, String m, Object ... e) {
        return new QueryException(this.parser.info(), new QNm(), m, e).suggest(this.parser, StringParser.list(comp));
    }

    private static StringList list(Enum<?>[] comp) {
        StringList list = new StringList();
        if (comp != null) {
            for (Enum<?> c : comp) {
                list.add(c.name().toLowerCase(Locale.ENGLISH));
            }
        }
        return list;
    }
}

