/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.Box;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogNew;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.basex.util.list.StringList;

final class DialogImport
extends BaseXBack {
    final BaseXLabel info;
    final BaseXTextField input;
    final BaseXButton browse;
    final BaseXCombo parsers;
    String dbname;
    private final GUI gui;
    private final DialogParsing parsing;
    private final BaseXCheckBox archives;
    private final BaseXCheckBox skipCorrupt;
    private final BaseXCheckBox addRaw;
    private final BaseXTextField filter;

    DialogImport(final BaseXDialog dial, BaseXBack panel, DialogParsing parse) {
        this.gui = dial.gui;
        this.parsing = parse;
        this.layout(new TableLayout(10, 1));
        this.border(8);
        this.add(new BaseXLabel(Text.FILE_OR_DIR + ":", true, true).border(0, 0, 6, 0));
        String path = this.gui.gopts.get(GUIOptions.INPUTPATH);
        this.input = new BaseXTextField(path, dial);
        this.input.history(GUIOptions.INPUTS, dial);
        IO io = IO.get(path);
        if (io instanceof IOFile && !path.isEmpty()) {
            this.dbname = io.dbname();
        }
        this.browse = new BaseXButton(Text.BROWSE_D, dial);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogImport.this.choose();
            }
        });
        BaseXBack b = new BaseXBack(new TableLayout(1, 2, 8, 0));
        b.add(this.input);
        b.add(this.browse);
        this.add(b);
        this.add(panel);
        this.add(Box.createVerticalStrut(12));
        MainOptions opts = this.gui.context.options;
        StringList ps = new StringList();
        for (MainOptions.MainParser mp : MainOptions.MainParser.values()) {
            ps.add(mp.name());
        }
        this.parsers = new BaseXCombo((Window)dial, ps.toArray());
        this.parsers.setSelectedItem(opts.get(MainOptions.PARSER).name());
        this.filter = new BaseXTextField(opts.get(MainOptions.CREATEFILTER), dial);
        BaseXLayout.setWidth(this.filter, 200);
        this.addRaw = new BaseXCheckBox(Text.ADD_RAW_FILES, MainOptions.ADDRAW, opts, dial);
        this.skipCorrupt = new BaseXCheckBox(Text.SKIP_CORRUPT_FILES, MainOptions.SKIPCORRUPT, opts, dial);
        this.archives = new BaseXCheckBox(Text.PARSE_ARCHIVES, MainOptions.ADDARCHIVES, opts, dial);
        BaseXBack p = new BaseXBack(new TableLayout(2, 2, 20, 0));
        p.add(new BaseXLabel(Text.INPUT_FORMAT, false, true).border(0, 0, 6, 0));
        p.add(new BaseXLabel(Text.FILE_PATTERNS + ":", false, true).border(0, 0, 6, 0));
        p.add(this.parsers);
        p.add(this.filter);
        this.add(p);
        this.add(Box.createVerticalStrut(8));
        this.add(this.addRaw);
        this.add(this.skipCorrupt);
        this.add(this.archives);
        this.info = new BaseXLabel(" ").border(32, 0, 6, 0);
        this.add(this.info);
        BaseXLayout.DropHandler dh = new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object object) {
                DialogImport.this.input.setText(object.toString());
                DialogImport.this.action(DialogImport.this.input, dial instanceof DialogNew);
            }
        };
        BaseXLayout.addDrop(this, dh);
        BaseXLayout.addDrop(this.input, dh);
    }

    String input() {
        return this.input.getText().trim();
    }

    IOFile inputFile() {
        String path = this.gui.gopts.get(GUIOptions.INPUTPATH);
        BaseXFileChooser fc = new BaseXFileChooser(Text.FILE_OR_DIR, path, this.gui);
        fc.textFilters();
        fc.filter("ZIP Archives", IO.ZIPSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
        if (file != null) {
            this.gui.gopts.set(GUIOptions.INPUTPATH, file.path());
        }
        return file;
    }

    boolean action(Object comp, boolean empty) {
        boolean ok = this.parsing.action();
        String in = this.input.getText().trim();
        IO io = IO.get(in);
        this.gui.gopts.set(GUIOptions.INPUTPATH, in);
        boolean multi = io.isDir() || io.isArchive();
        this.archives.setEnabled(multi);
        this.filter.setEnabled(multi &= this.archives.isSelected());
        MainOptions.MainParser parser = MainOptions.MainParser.valueOf(this.parsers.getSelectedItem());
        boolean raw = parser == MainOptions.MainParser.RAW;
        this.addRaw.setEnabled(multi && !raw && this.gui.context.options.get(MainOptions.MAINMEM) == false);
        this.skipCorrupt.setEnabled(!raw);
        if (comp == this.parsers) {
            this.parsing.setType(parser);
            if (multi) {
                this.filter.setText(raw ? "*" : "*." + (Object)((Object)parser));
            }
        }
        boolean bl = empty ? in.isEmpty() || io.exists() : !in.isEmpty() && io.exists();
        if ((ok &= bl) && comp == this.input) {
            this.setType(in);
        }
        this.info.setText(null, null);
        return ok;
    }

    void setOptions() {
        this.gui.set(MainOptions.PARSER, MainOptions.MainParser.valueOf(this.parsers.getSelectedItem()));
        this.gui.set(MainOptions.CREATEFILTER, this.filter.getText());
        this.gui.set(MainOptions.ADDARCHIVES, this.archives.isSelected());
        this.gui.set(MainOptions.SKIPCORRUPT, this.skipCorrupt.isSelected());
        this.gui.set(MainOptions.ADDRAW, this.addRaw.isSelected());
        this.input.store();
        this.parsing.setOptions();
    }

    void choose() {
        IOFile in = this.inputFile();
        if (in == null) {
            return;
        }
        this.input.setText(in.path());
        this.setType(in.path());
    }

    void setType(String in) {
        IO io = IO.get(in);
        if (!in.isEmpty() && io instanceof IOFile) {
            this.dbname = io.dbname();
        }
        boolean dir = io.isDir();
        boolean archive = io.isArchive();
        if (dir || archive) {
            return;
        }
        MainOptions.MainParser type = null;
        String path = io.path();
        int i = path.lastIndexOf(46);
        if (i != -1) {
            String suf = path.substring(i).toLowerCase(Locale.ENGLISH);
            if (Token.eq(suf, IO.XMLSUFFIXES) || Token.eq(suf, IO.XSLSUFFIXES)) {
                type = MainOptions.MainParser.XML;
            } else if (Token.eq(suf, IO.HTMLSUFFIXES)) {
                type = MainOptions.MainParser.HTML;
            } else if (Token.eq(suf, ".csv")) {
                type = MainOptions.MainParser.CSV;
            } else if (Token.eq(suf, IO.TXTSUFFIXES)) {
                type = MainOptions.MainParser.TEXT;
            } else if (Token.eq(suf, ".json")) {
                type = MainOptions.MainParser.JSON;
            }
        }
        if (type == null) {
            type = DialogImport.guess(io);
        }
        if (type == null) {
            type = MainOptions.MainParser.XML;
        }
        this.parsers.setSelectedItem(type.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MainOptions.MainParser guess(IO in) {
        if (!in.exists()) return null;
        if (in instanceof IOUrl) {
            return null;
        }
        BufferInput ti = null;
        try {
            ti = new BufferInput(in);
            int b = ti.read();
            if (b == 60) {
                MainOptions.MainParser mainParser = MainOptions.MainParser.XML;
                return mainParser;
            }
            int c = 0;
            while (b >= 0 && ++c < 4096) {
                if (b < 32 && !Token.ws(b) || b >= 128) {
                    MainOptions.MainParser ignored = MainOptions.MainParser.RAW;
                    return ignored;
                }
                b = ti.read();
            }
            MainOptions.MainParser mainParser = MainOptions.MainParser.TEXT;
            return mainParser;
        }
        catch (IOException ignored) {
            return null;
        }
        finally {
            if (ti != null) {
                try {
                    ti.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

