/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.Databases;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.List;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogFT;
import org.basex.gui.dialog.DialogImport;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogNew
extends BaseXDialog {
    private final DialogImport general;
    private final BaseXTextField dbname;
    private final BaseXBack buttons = this.okCancel();
    private final BaseXCheckBox txtindex;
    private final BaseXCheckBox atvindex;
    private final BaseXCheckBox ftxindex;
    private final DialogFT ft;
    private final StringList db;

    public DialogNew(GUI main) {
        super(main, Text.CREATE_DATABASE);
        this.db = List.list(main.context);
        MainOptions opts = this.gui.context.options;
        GUIOptions gopts = main.gopts;
        this.dbname = new BaseXTextField(gopts.get(GUIOptions.DBNAME), this);
        BaseXBack pnl = new BaseXBack(new TableLayout(2, 1));
        pnl.add(new BaseXLabel(Text.NAME_OF_DB + ": ", false, true).border(8, 0, 6, 0));
        pnl.add(this.dbname);
        BaseXTabs tabs = new BaseXTabs(this);
        DialogParsing parsing = new DialogParsing(this, tabs);
        this.general = new DialogImport(this, pnl, parsing);
        BaseXBack indexes = new BaseXBack(new TableLayout(6, 1, 0, 0)).border(8);
        this.txtindex = new BaseXCheckBox(Text.TEXT_INDEX, MainOptions.TEXTINDEX, opts, this).bold().large();
        indexes.add(this.txtindex);
        indexes.add(new BaseXLabel(Text.H_TEXT_INDEX, true, false));
        this.atvindex = new BaseXCheckBox(Text.ATTRIBUTE_INDEX, MainOptions.ATTRINDEX, opts, this).bold().large();
        indexes.add(this.atvindex);
        indexes.add(new BaseXLabel(Text.H_ATTR_INDEX, true, false));
        this.ftxindex = new BaseXCheckBox(Text.FULLTEXT_INDEX, MainOptions.FTINDEX, opts, this).bold().large();
        indexes.add(this.ftxindex);
        this.ft = new DialogFT(this, true);
        indexes.add(this.ft);
        tabs.addTab(Text.GENERAL, this.general);
        tabs.addTab(Text.PARSING, parsing);
        tabs.addTab(Text.INDEXES, indexes);
        this.set(tabs, "Center");
        this.set(this.buttons, "South");
        this.general.setType(this.general.input());
        this.action(this.general.parsers);
        this.setResizable(true);
        this.finish(null);
    }

    @Override
    public void action(Object comp) {
        boolean valid = this.general.action(comp, true);
        this.ft.action(this.ftxindex.isSelected());
        if (comp == this.general.browse || comp == this.general.input) {
            this.dbname.setText(this.general.dbname);
        }
        String nm = this.dbname.getText().trim();
        boolean bl = this.ok = valid && !nm.isEmpty();
        String inf = valid ? (this.ok ? null : Text.ENTER_DB_NAME) : Text.RES_NOT_FOUND;
        GUIConstants.Msg icon = GUIConstants.Msg.ERROR;
        if (this.ok) {
            this.ok = Databases.validName(nm);
            if (this.ok) {
                this.gui.gopts.set(GUIOptions.DBNAME, nm);
            }
            if (!this.ok) {
                inf = Util.info(Text.INVALID_X, Text.NAME);
            } else if (this.general.input.getText().trim().isEmpty()) {
                inf = Text.EMPTY_DB;
                icon = GUIConstants.Msg.WARN;
            } else if (this.db.contains(nm)) {
                inf = Text.OVERWRITE_DB;
                icon = GUIConstants.Msg.WARN;
            }
        }
        this.general.info.setText(inf, icon);
        DialogNew.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        this.gui.set(MainOptions.TEXTINDEX, this.txtindex.isSelected());
        this.gui.set(MainOptions.ATTRINDEX, this.atvindex.isSelected());
        this.gui.set(MainOptions.FTINDEX, this.ftxindex.isSelected());
        this.general.setOptions();
        this.ft.setOptions();
    }
}

