/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLayout;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;

public final class BaseXCheckBox
extends JCheckBox {
    private Options options;
    private BooleanOption option;

    public BaseXCheckBox(String label, BooleanOption opt, Options opts, Window win) {
        this(label, opts.get(opt), win);
        this.options = opts;
        this.option = opt;
    }

    public BaseXCheckBox(String label, boolean sel, Window win) {
        super(label, sel);
        this.setOpaque(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        BaseXLayout.addInteraction(this, win);
        if (!(win instanceof BaseXDialog)) {
            return;
        }
        final BaseXDialog dialog = (BaseXDialog)win;
        BaseXLayout.setMnemonic(this, dialog.mnem);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.action(e.getSource());
            }
        });
    }

    public BaseXCheckBox bold() {
        this.setFont(this.getFont().deriveFont(1));
        return this;
    }

    public BaseXCheckBox large() {
        Font f = this.getFont();
        this.setFont(new Font(f.getName(), 0, (int)f.getSize2D() + 4));
        return this;
    }

    public void assign() {
        this.options.set(this.option, this.isSelected());
    }
}

