/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class BaseXList
extends BaseXBack {
    private final boolean single;
    private final BaseXTextField text;
    private final JList list;
    private final JScrollPane scroll;
    private String[] values;
    private boolean num = true;

    public BaseXList(String[] choice, BaseXDialog d) {
        this(choice, d, true);
    }

    public BaseXList(String[] choice, final BaseXDialog d, boolean s) {
        this.values = (String[])choice.clone();
        this.single = s;
        for (String v : this.values) {
            this.num = this.num && v.matches("[0-9]+");
        }
        this.layout(new TableLayout(2, 1));
        this.text = new BaseXTextField(d);
        this.text.addKeyListener(new KeyAdapter(){
            boolean multi;
            boolean typed;
            String old = "";

            @Override
            public void keyPressed(KeyEvent e) {
                int page = BaseXList.this.getHeight() / BaseXList.this.getFont().getSize();
                int[] inds = BaseXList.this.list.getSelectedIndices();
                int op1 = inds.length == 0 ? -1 : inds[0];
                int op2 = inds.length == 0 ? -1 : inds[inds.length - 1];
                int np1 = op1;
                int np2 = op2;
                if (BaseXKeys.NEXTLINE.is(e)) {
                    np2 = Math.min(op2 + 1, BaseXList.this.values.length - 1);
                } else if (BaseXKeys.PREVLINE.is(e)) {
                    np1 = Math.max(op1 - 1, 0);
                } else if (BaseXKeys.NEXTPAGE.is(e)) {
                    np2 = Math.min(op2 + page, BaseXList.this.values.length - 1);
                } else if (BaseXKeys.PREVPAGE.is(e)) {
                    np1 = Math.max(op1 - page, 0);
                } else if (BaseXKeys.TEXTSTART.is(e)) {
                    np1 = 0;
                } else if (BaseXKeys.TEXTEND.is(e)) {
                    np2 = BaseXList.this.values.length - 1;
                } else {
                    return;
                }
                IntList il = new IntList();
                for (int n = np1; n <= np2; ++n) {
                    il.add(n);
                }
                int nv = op2 == np2 ? np1 : np2;
                String val = BaseXList.this.values[nv];
                BaseXList.this.list.setSelectedValue(val, true);
                if (e.isShiftDown() && !BaseXList.this.single) {
                    BaseXList.this.list.setSelectedIndices(il.toArray());
                    BaseXList.this.text.setText("");
                } else {
                    BaseXList.this.list.setSelectedIndex(nv);
                    BaseXList.this.text.setText(val);
                    BaseXList.this.text.selectAll();
                }
                this.multi = il.size() > 1;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                if (BaseXList.this.num) {
                    boolean bl = this.typed = ch >= '0' && ch <= '9';
                    if (!this.typed) {
                        e.consume();
                    }
                } else {
                    this.typed = ch >= ' ' && ch != '\u007f';
                }
                this.multi = false;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String txt = BaseXList.this.text.getText().trim().toLowerCase(Locale.ENGLISH);
                if (!txt.equals(this.old) && !this.multi) {
                    boolean glob = txt.matches("^.*[*?,].*$");
                    String regex = glob ? IOFile.regex(txt, false) : null;
                    IntList il = new IntList();
                    for (int v = 0; v < BaseXList.this.values.length; ++v) {
                        String value = BaseXList.this.values[v].trim().toLowerCase(Locale.ENGLISH);
                        if (glob) {
                            if (!value.matches(regex)) continue;
                            il.add(v);
                            continue;
                        }
                        if (!value.startsWith(txt)) continue;
                        if (this.typed) {
                            int c = BaseXList.this.text.getCaretPosition();
                            BaseXList.this.text.setText(BaseXList.this.values[v]);
                            BaseXList.this.text.select(c, BaseXList.this.values[v].length());
                            txt = value;
                        }
                        il.add(v);
                        break;
                    }
                    if (!il.isEmpty()) {
                        BaseXList.this.list.setSelectedValue(BaseXList.this.values[il.get(il.size() - 1)], true);
                    }
                    BaseXList.this.list.setSelectedIndices(il.toArray());
                }
                d.action(BaseXList.this);
                this.typed = false;
                this.old = txt;
            }
        });
        this.add(this.text);
        MouseInputAdapter mouse = new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseXLayout.focus(BaseXList.this.text);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Object[] i = BaseXList.this.list.getSelectedValues();
                BaseXList.this.text.setText(i.length == 1 ? i[0].toString() : "");
                BaseXList.this.text.requestFocusInWindow();
                BaseXList.this.text.selectAll();
                d.action(BaseXList.this);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    d.close();
                }
            }
        };
        this.list = new JList<String>(choice);
        this.list.setFocusable(false);
        if (s) {
            this.list.setSelectionMode(0);
        }
        this.list.addMouseListener(mouse);
        this.list.addMouseMotionListener(mouse);
        this.text.setFont(this.list.getFont());
        BaseXLayout.setWidth(this.text, this.list.getWidth());
        BaseXLayout.addInteraction(this.list, d);
        this.scroll = new JScrollPane(this.list);
        this.add(this.scroll);
        this.setIndex(0);
    }

    public void setValue(String value) {
        this.list.setSelectedValue(value, true);
        this.text.setText(value);
    }

    @Override
    public void setEnabled(boolean en) {
        this.list.setEnabled(en);
        this.text.setEnabled(en);
    }

    public void setFont(String font, int style) {
        Font f = this.text.getFont();
        this.text.setFont(new Font(font, style, f.getSize()));
    }

    public String[] getList() {
        return this.values;
    }

    public String getValue() {
        Object[] vals = this.list.getSelectedValues();
        return vals.length == 1 ? vals[0].toString() : "";
    }

    public StringList getValues() {
        StringList sl = new StringList();
        for (Object o : this.list.getSelectedValues()) {
            sl.add(o.toString());
        }
        return sl;
    }

    public int getNum() {
        int i = Token.toInt(this.text.getText());
        if (i != Integer.MIN_VALUE) {
            return i;
        }
        Object value = this.list.getSelectedValue();
        return value != null ? Token.toInt(value.toString()) : 0;
    }

    public int getIndex() {
        return this.list.getSelectedIndex();
    }

    void setIndex(int i) {
        if (i < this.values.length) {
            this.setValue(this.values[i]);
        } else {
            this.text.setText("");
        }
    }

    @Override
    public void setSize(int w, int h) {
        BaseXLayout.setWidth(this.text, w);
        BaseXLayout.setSize(this.scroll, w, h);
    }

    public void setWidth(int w) {
        BaseXLayout.setWidth(this.text, w);
        BaseXLayout.setWidth(this.scroll, w);
    }

    public void setData(String[] data) {
        this.values = (String[])data.clone();
        this.list.setListData(data);
        this.setIndex(0);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }
}

