/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;

public final class BaseXPopup
extends JPopupMenu {
    private final GUI gui;
    private final GUICommand[] commands;

    public BaseXPopup(BaseXPanel comp, GUICommand ... cmds) {
        this((JComponent)comp, comp.gui, cmds);
    }

    public BaseXPopup(JComponent comp, final GUI g, final GUICommand ... cmds) {
        this.commands = cmds;
        this.gui = g;
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!((BaseXPopup)BaseXPopup.this).gui.updating && e.isPopupTrigger()) {
                    BaseXPopup.this.show(e.getComponent(), e.getX() - 10, e.getY() - 15);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!((BaseXPopup)BaseXPopup.this).gui.updating && BaseXKeys.CONTEXT.is(e)) {
                    BaseXPopup.this.show(e.getComponent(), 10, 10);
                } else {
                    for (GUICommand cmd : cmds) {
                        if (!(cmd instanceof GUIPopupCmd)) continue;
                        for (BaseXKeys sc : ((GUIPopupCmd)cmd).shortcuts()) {
                            if (!sc.is(e)) continue;
                            cmd.execute(g);
                            e.consume();
                            return;
                        }
                    }
                }
            }
        });
        StringBuilder mnemCache = new StringBuilder();
        for (final GUICommand cmd : cmds) {
            if (cmd == null) {
                this.addSeparator();
                continue;
            }
            JMenuItem item = this.add(cmd.label());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!((BaseXPopup)BaseXPopup.this).gui.updating) {
                        cmd.execute(BaseXPopup.this.gui);
                    }
                }
            });
            BaseXLayout.setMnemonic(item, mnemCache);
            item.setAccelerator(BaseXLayout.keyStroke(cmd));
        }
    }

    @Override
    public void show(Component comp, int x, int y) {
        for (int b = 0; b < this.commands.length; ++b) {
            if (this.commands[b] == null) continue;
            AbstractButton button = (AbstractButton)this.getComponent(b);
            button.setEnabled(this.commands[b].enabled(this.gui));
            button.setSelected(this.commands[b].selected(this.gui));
        }
        super.show(comp, x, y);
    }
}

