/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.editor.EditorView;
import org.basex.io.IOFile;
import org.basex.util.Util;

public final class EditorArea
extends TextPanel {
    final BaseXLabel label;
    IOFile file;
    boolean modified;
    byte[] last;
    boolean script;
    private final EditorView view;
    private long tstamp;

    EditorArea(EditorView v, IOFile f) {
        super(true, v.gui);
        this.view = v;
        this.file = f;
        this.label = new BaseXLabel(f.name());
        this.label.setIcon(BaseXImages.file(new IOFile(".xq")));
        this.setSyntax(f, false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                String path = EditorArea.this.file.path();
                EditorArea.this.gui.context.options.set(MainOptions.QUERYPATH, path);
                EditorArea.this.gui.gopts.set(GUIOptions.WORKPATH, EditorArea.this.file.dirPath());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (EditorArea.this.reopen(false)) {
                            return;
                        }
                    }
                });
            }
        });
    }

    public boolean opened() {
        return this.tstamp != 0L;
    }

    public IOFile file() {
        return this.file;
    }

    public void initText(byte[] t) {
        this.last = t;
        super.setText(t);
        this.hist.init(this.getText());
    }

    @Override
    public void setText(byte[] t) {
        this.last = this.getText();
        super.setText(t);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.view.posCode.invokeLater();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        byte[] text = this.editor.text();
        super.keyPressed(e);
        if (text != this.editor.text()) {
            this.resetError();
        }
        this.view.posCode.invokeLater();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        byte[] text = this.editor.text();
        super.keyTyped(e);
        if (text != this.editor.text()) {
            this.resetError();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
        if (BaseXKeys.EXEC1.is(e) || BaseXKeys.EXEC2.is(e)) {
            this.release(TextPanel.Action.EXECUTE);
        } else if ((!e.isActionKey() || BaseXKeys.MOVEDOWN.is(e) || BaseXKeys.MOVEUP.is(e)) && !BaseXKeys.modifier(e)) {
            this.release(TextPanel.Action.CHECK);
        }
    }

    @Override
    protected void release(TextPanel.Action action) {
        this.view.run(this, action);
    }

    public boolean reopen(boolean enforce) {
        if (this.opened()) {
            long ts = this.file.timeStamp();
            if (!(this.tstamp == ts && !enforce || this.modified && !BaseXDialog.confirm(this.gui, Util.info(Text.REOPEN_FILE_X, this.file.name())))) {
                try {
                    this.setText(this.file.read());
                    this.file(this.file);
                    this.release(TextPanel.Action.PARSE);
                    return true;
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_OPENED_X, this.file));
                }
            }
            this.tstamp = ts;
        }
        return false;
    }

    boolean save() {
        return this.save(this.file);
    }

    boolean save(IOFile io) {
        boolean same;
        boolean bl = same = io == this.file;
        if (same && !this.modified) {
            return false;
        }
        try {
            io.write(this.getText());
            this.file(io);
            this.view.project.refresh(io, true);
            return true;
        }
        catch (Exception ex) {
            BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_SAVED_X, io));
            return false;
        }
    }

    public void jump(String string) {
        if (string != null) {
            this.search.reset();
            this.search.activate(string, false);
            this.jump(TextPanel.SearchDir.CURRENT, true);
        } else {
            this.search.deactivate(true);
        }
        this.requestFocusInWindow();
    }

    void file(IOFile io) {
        if (io != this.file) {
            this.file = io;
            this.label.setIcon(BaseXImages.file(io));
            this.setSyntax(io, true);
        }
        this.tstamp = this.file.timeStamp();
        this.hist.save();
        this.view.refreshHistory(this.file);
        this.view.refreshControls(this, true);
    }
}

