/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.explore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.JTextComponent;
import org.basex.core.Text;
import org.basex.core.cmd.Find;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDSlider;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.explore.ExploreView;
import org.basex.index.name.Names;
import org.basex.index.stats.Stats;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class ExploreArea
extends BaseXPanel
implements ActionListener {
    private static final int COMPW = 150;
    private static final String PATEX = "[% = \"%\"]";
    private static final String PATSUB = "[% contains text \"%\"]";
    private static final String PATNUM = "[% >= % and % <= %]";
    private static final String PATSIMPLE = "[%]";
    private final ExploreView main;
    private final BaseXBack panel;
    private final BaseXTextField all;
    private String last = "";

    ExploreArea(ExploreView m) {
        super(m.gui);
        this.main = m;
        this.layout(new BorderLayout(0, 5)).mode(GUIConstants.Fill.NONE);
        this.all = new BaseXTextField(this.gui);
        this.all.addKeyListener(this.main);
        this.all.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExploreArea.this.query(false);
            }
        });
        this.add((Component)this.all, "North");
        this.panel = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(32, 2, 10, 5));
        this.add((Component)this.panel, "Center");
    }

    void init() {
        this.panel.removeAll();
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Data data = this.gui.context.data();
        if (!this.main.visible() || data == null || this.panel.getComponentCount() != 0) {
            return;
        }
        this.addKeys(this.gui.context.data());
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void addInput(int pos) {
        BaseXTextField txt = new BaseXTextField(this.gui);
        BaseXLayout.setWidth(txt, 150);
        BaseXLayout.setHeight(txt, txt.getFont().getSize() + 11);
        txt.setMargin(new Insets(0, 0, 0, 10));
        txt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExploreArea.this.query(false);
            }
        });
        txt.addKeyListener(this.main);
        this.panel.add((Component)txt, pos);
    }

    private void addKeys(Data data) {
        TokenList tl = new TokenList();
        int cs = this.panel.getComponentCount();
        for (int c = 0; c < cs; c += 2) {
            String elem;
            BaseXCombo combo = (BaseXCombo)this.panel.getComponent(c);
            if (combo.getSelectedIndex() == 0 || (elem = combo.getSelectedItem()).startsWith("@")) continue;
            tl.add(Token.token(elem));
        }
        String[] keys = ExploreArea.entries(data.paths.desc(tl, true, false));
        BaseXCombo cm = new BaseXCombo((Window)this.gui, keys);
        cm.addActionListener(this);
        cm.addKeyListener(this.main);
        if (keys.length == 1) {
            cm.setEnabled(false);
        }
        this.panel.add(cm);
        this.panel.add(new BaseXLabel(""));
    }

    private void addCombo(String[] values, int pos) {
        BaseXCombo cm = new BaseXCombo((Window)this.gui, values);
        BaseXLayout.setWidth(cm, 150);
        cm.addActionListener(this);
        cm.addKeyListener(this.main);
        this.panel.add((Component)cm, pos);
    }

    private void addSlider(double min, double max, int pos, boolean itr) {
        BaseXDSlider sl = new BaseXDSlider(min, max, this.gui, this);
        BaseXLayout.setWidth(sl, 450);
        sl.itr = itr;
        sl.addKeyListener(this.main);
        this.panel.add((Component)sl, pos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            Object source = e.getSource();
            int cp = 0;
            int cs = this.panel.getComponentCount();
            for (int c = 0; c < cs; ++c) {
                if (this.panel.getComponent(c) != source) continue;
                cp = c;
            }
            if (!(cp & true)) {
                boolean selected;
                BaseXCombo combo = (BaseXCombo)source;
                this.panel.remove(cp + 1);
                Data data = this.gui.context.data();
                boolean bl = selected = combo.getSelectedIndex() != 0;
                if (selected) {
                    String item = combo.getSelectedItem();
                    boolean att = item.startsWith("@");
                    Names names = att ? data.atnindex : data.tagindex;
                    byte[] key = Token.token(att ? item.substring(1) : item);
                    Stats stat = names.stat(names.id(key));
                    switch (stat.type) {
                        case INTEGER: {
                            this.addSlider(stat.min, stat.max, cp + 1, true);
                            break;
                        }
                        case DOUBLE: {
                            this.addSlider(stat.min, stat.max, cp + 1, false);
                            break;
                        }
                        case CATEGORY: {
                            this.addCombo(ExploreArea.entries(new TokenList(stat.cats)), cp + 1);
                            break;
                        }
                        case TEXT: {
                            this.addInput(cp + 1);
                            break;
                        }
                        case NONE: {
                            this.panel.add((Component)new BaseXLabel(""), cp + 1);
                        }
                    }
                } else {
                    this.panel.add((Component)new BaseXLabel(""), cp + 1);
                }
                while (cp + 2 < this.panel.getComponentCount()) {
                    this.panel.remove(cp + 2);
                    this.panel.remove(cp + 2);
                }
                if (selected) {
                    this.addKeys(data);
                }
                this.panel.revalidate();
                this.panel.repaint();
            }
        }
        this.query(false);
    }

    void query(boolean force) {
        String simple;
        TokenBuilder tb = new TokenBuilder();
        Data data = this.gui.context.data();
        int cs = this.panel.getComponentCount();
        for (int c = 0; c < cs; c += 2) {
            BaseXCombo com = (BaseXCombo)this.panel.getComponent(c);
            int k = com.getSelectedIndex();
            if (k <= 0) continue;
            String key = com.getSelectedItem().replaceAll("^(@?)(.*):", "$1*:");
            boolean attr = key.startsWith("@");
            Component comp = this.panel.getComponent(c + 1);
            String pattern = "";
            String val1 = null;
            String val2 = null;
            if (comp instanceof BaseXTextField) {
                val1 = ((JTextComponent)comp).getText();
                if (!val1.isEmpty()) {
                    if (val1.startsWith("\"")) {
                        val1 = val1.replaceAll("\"", "");
                        pattern = PATEX;
                    } else {
                        pattern = attr && data.meta.attrindex || !attr && data.meta.textindex ? PATSUB : PATEX;
                    }
                }
            } else if (comp instanceof BaseXCombo) {
                BaseXCombo combo = (BaseXCombo)comp;
                if (combo.getSelectedIndex() != 0) {
                    val1 = combo.getSelectedItem();
                    pattern = PATEX;
                }
            } else if (comp instanceof BaseXDSlider) {
                BaseXDSlider slider = (BaseXDSlider)comp;
                if (slider.min != slider.totMin || slider.max != slider.totMax) {
                    double m = slider.min;
                    double n = slider.max;
                    val1 = (double)((long)m) == m ? Long.toString((long)m) : Double.toString(m);
                    val2 = (double)((long)n) == n ? Long.toString((long)n) : Double.toString(n);
                    pattern = PATNUM;
                }
            }
            if (attr) {
                key = "descendant-or-self::node()/" + key;
                if (tb.isEmpty()) {
                    tb.add("//*");
                }
                if (pattern.isEmpty()) {
                    pattern = PATSIMPLE;
                }
            } else {
                tb.add("//" + key);
                key = "text()";
            }
            tb.addExt(pattern, key, val1, key, val2);
        }
        String qu = tb.toString();
        boolean root = this.gui.context.root();
        boolean rt = this.gui.gopts.get(GUIOptions.FILTERRT);
        if (!(qu.isEmpty() || rt || root)) {
            qu = '.' + qu;
        }
        if (!(simple = this.all.getText().trim()).isEmpty()) {
            simple = Find.find(simple, this.gui.context, rt);
            String string = qu = qu.isEmpty() ? simple : simple + " | " + qu;
        }
        if (qu.isEmpty()) {
            String string = qu = rt || root ? "/" : ".";
        }
        if (!force && this.last.equals(qu)) {
            return;
        }
        this.last = qu;
        this.gui.xquery(qu, false);
    }

    private static String[] entries(TokenList keys) {
        StringList sl = new StringList();
        sl.add(Util.info(Text.ENTRIES, keys.size()));
        for (byte[] k : keys) {
            sl.add(Token.string(k));
        }
        return sl.sort(true, true, 1).toArray();
    }
}

