/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;

public abstract class ProjectNode
extends DefaultMutableTreeNode {
    protected final ProjectView project;
    protected IOFile file;

    ProjectNode(IOFile io, ProjectView proj) {
        super(io == null ? null : io.name());
        this.file = io;
        this.project = proj;
    }

    @Override
    public void setUserObject(Object uo) {
        IOFile renamed = this.project.rename(this, uo.toString());
        if (renamed != null) {
            this.file = renamed;
            this.refresh();
        }
    }

    abstract void expand();

    abstract void collapse();

    final void refresh() {
        this.collapse();
        this.expand();
        this.updateTree();
    }

    final void updateTree() {
        DefaultTreeModel model = (DefaultTreeModel)this.project.tree.getModel();
        model.nodeStructureChanged(this);
        this.project.repaint();
    }

    final TreePath path() {
        DefaultTreeModel model = (DefaultTreeModel)this.project.tree.getModel();
        return new TreePath(model.getPathToRoot(this));
    }

    final boolean root() {
        return this.getParent().getParent() == null;
    }
}

