/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.TreeNode;
import org.basex.core.GlobalOptions;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.editor.EditorView;
import org.basex.gui.view.project.ProjectDir;
import org.basex.gui.view.project.ProjectFilter;
import org.basex.gui.view.project.ProjectList;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectTree;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class ProjectView
extends BaseXPanel {
    final ProjectDir root;
    final ProjectTree tree;
    final EditorView editor;
    final ProjectFilter filter;
    final ProjectList list;
    final BaseXTextField path;
    private final BaseXSplit split;
    private Component last;
    final FocusAdapter lastfocus = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent ev) {
            ProjectView.this.last = ev.getComponent();
        }
    };

    public ProjectView(EditorView ev) {
        super(ev.gui);
        this.editor = ev;
        this.setLayout(new BorderLayout());
        this.tree = new ProjectTree(this);
        this.root = new ProjectDir(new IOFile(this.root()), this);
        this.tree.init(this.root);
        this.filter = new ProjectFilter(this);
        this.list = new ProjectList(this);
        BaseXLayout.addInteraction(this.list, this.gui);
        BaseXBack back = new BaseXBack().layout(new BorderLayout(2, 2));
        back.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, GUIConstants.GRAY), new EmptyBorder(3, 1, 3, 2)));
        this.path = new BaseXTextField(this.gui);
        this.path.setText(this.root.file.path());
        this.path.setEnabled(false);
        BaseXButton browse = new BaseXButton("...", this.gui);
        browse.setMargin(new Insets(0, 2, 0, 2));
        browse.setToolTipText(Text.CHOOSE_DIR + "...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.change();
            }
        });
        back.add((Component)this.path, "Center");
        back.add((Component)browse, "East");
        back.add((Component)this.filter, "South");
        JScrollPane lscroll = new JScrollPane(this.list);
        lscroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        JScrollPane tscroll = new JScrollPane(this.tree);
        tscroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.split = new BaseXSplit(false);
        this.split.mode(GUIConstants.Fill.NONE);
        this.split.add(lscroll);
        this.split.add(tscroll);
        this.split.init(new double[]{0.3, 0.7}, new double[]{0.0, 1.0});
        this.split.visible(false);
        this.showList(false);
        this.add((Component)back, "North");
        this.add((Component)this.split, "Center");
        this.last = this.tree;
        this.tree.addFocusListener(this.lastfocus);
        this.list.addFocusListener(this.lastfocus);
    }

    public void showList(boolean vis) {
        this.split.visible(vis);
    }

    public void refresh(IOFile file, boolean tr) {
        if (tr) {
            this.refresh(file);
        }
        this.filter.refresh(true);
    }

    public void jump(IOFile file) {
        IOFile fl = new IOFile(this.canonical(file.file()));
        if (fl.path().startsWith(this.root.file.path())) {
            this.tree.expand(this.root, fl.path());
        }
        this.tree.requestFocusInWindow();
    }

    private void refresh(IOFile file) {
        ProjectNode node = this.find(file);
        if (node != null) {
            node.refresh();
        } else {
            File parent = file.file().getParentFile();
            if (parent == null) {
                return;
            }
            this.refresh(new IOFile(parent));
        }
    }

    private ProjectNode find(IOFile file) {
        IOFile fl = new IOFile(this.canonical(file.file()));
        if (fl.path().startsWith(this.root.file.path())) {
            Enumeration<TreeNode> en = this.root.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                ProjectNode node = (ProjectNode)en.nextElement();
                if (node.file == null || !node.file.path().equals(fl.path())) continue;
                return node;
            }
        }
        return null;
    }

    public void findFiles(EditorArea ea) {
        if (this.isFocusOwner()) {
            this.filter.find(this.tree.selectedNode());
        } else {
            this.filter.find(ea);
        }
    }

    public void focus() {
        this.last.requestFocusInWindow();
    }

    IOFile rename(ProjectNode node, String name) {
        if (IOFile.isValidName(name)) {
            IOFile old = node.file;
            IOFile updated = new IOFile(old.file().getParent(), name);
            if (!old.rename(updated)) {
                BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_RENAMED_X, old));
            } else {
                this.gui.editor.rename(old, updated);
                return updated;
            }
        }
        return null;
    }

    private String root() {
        GlobalOptions gopts = this.gui.context.globalopts;
        String proj = this.gui.gopts.get(GUIOptions.PROJECTPATH);
        if (!proj.isEmpty()) {
            return proj;
        }
        File io1 = new File(gopts.get(GlobalOptions.REPOPATH));
        File io2 = new File(gopts.get(GlobalOptions.WEBPATH));
        File fl = new File(gopts.get(GlobalOptions.RESTXQPATH));
        File io3 = fl.isAbsolute() ? fl : new File(io2, fl.getPath());
        StringList sl = new StringList();
        for (File f : new File[]{io1, io2, io3}) {
            String p = this.canonical(f).getParent();
            if (sl.contains(p)) continue;
            sl.add(p);
        }
        return sl.unique().get(0);
    }

    private File canonical(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ex) {
            return f.getAbsoluteFile();
        }
    }

    void open(IOFile file, final String search) {
        final EditorArea ea = this.editor.open(file);
        if (ea == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ea.jump(search);
            }
        });
    }

    void change() {
        ProjectNode child = this.tree.selectedNode();
        BaseXFileChooser fc = new BaseXFileChooser(Text.CHOOSE_DIR, child.file.path(), this.gui);
        IOFile io = fc.select(BaseXFileChooser.Mode.DOPEN);
        if (io != null) {
            this.root.file = io;
            this.root.refresh();
            this.filter.reset();
            this.path.setText(io.path());
            this.gui.gopts.set(GUIOptions.PROJECTPATH, io.path());
        }
    }
}

