/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.view.table.TableData;
import org.basex.gui.view.table.TableInput;
import org.basex.gui.view.table.TableView;
import org.basex.util.Token;

final class TableHeader
extends BaseXPanel {
    private final TableView view;
    private final TableData tdata;
    private TableInput box;
    private int inputCol = -1;
    private boolean header;
    private int clickCol = -1;
    private int moveC = -1;
    private int mouseX = -1;

    TableHeader(TableView v) {
        super(v.gui);
        this.mode(GUIConstants.Fill.NONE).setFocusable(true);
        this.tdata = v.tdata;
        this.view = v;
        BaseXLayout.setHeight(this, GUIConstants.fontSize + 8 << 1);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TableHeader.this.filter(e.getOppositeComponent() instanceof TableView ? 0 : ((TableHeader)TableHeader.this).tdata.cols.length - 1);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (TableHeader.this.box != null) {
                    TableHeader.this.box.stop();
                }
                TableHeader.this.inputCol = -1;
                TableHeader.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(GUIConstants.font);
        g.setColor(Color.black);
        if (this.tdata.rows == null) {
            BaseXLayout.drawCenter(g, Text.NO_DATA, this.getWidth(), this.getHeight() / 2);
            return;
        }
        int fsz = GUIConstants.fontSize;
        int w = this.getWidth();
        int h = this.getHeight();
        int hh = h >> 1;
        g.setColor(GUIConstants.color2);
        g.drawLine(0, h - 1, w, h - 1);
        int bs = 16;
        w -= 16;
        double x = 0.0;
        int nc = this.tdata.cols.length;
        for (int n = 0; n < nc; ++n) {
            double cw = (double)w * this.tdata.cols[n].width;
            double ce = x + cw;
            boolean clicked = n == this.clickCol && this.moveC == -1 && this.header;
            BaseXLayout.drawCell(g, (int)x, (int)ce + 1, 0, hh, clicked);
            g.setColor(Color.white);
            g.fillRect((int)x + 1, hh, (int)ce - (int)x - 2, hh - 2);
            g.drawLine((int)ce - 1, hh - 1, (int)ce - 1, h - 2);
            g.setColor(GUIConstants.GRAY);
            g.drawLine((int)ce, hh - 1, (int)ce, h - 2);
            g.setColor(Color.black);
            g.setFont(GUIConstants.bfont);
            int off = clicked ? 1 : 0;
            BaseXLayout.chopString(g, this.tdata.cols[n].name, (int)x + 4 + off, 2 + off, (int)cw, fsz);
            if (n == this.tdata.sortCol) {
                if (this.tdata.asc) {
                    g.fillPolygon(new int[]{(int)ce - 9 + off, (int)ce - 3 + off, (int)ce - 6 + off}, new int[]{4 + off, 4 + off, 8 + off}, 3);
                } else {
                    g.fillPolygon(new int[]{(int)ce - 9 + off, (int)ce - 3 + off, (int)ce - 6 + off}, new int[]{8 + off, 8 + off, 4 + off}, 3);
                }
            }
            if (this.box != null && this.inputCol == n) {
                this.box.paint(g, (int)x, hh, (int)ce - (int)x, hh);
            } else {
                g.setColor(Color.black);
                g.setFont(GUIConstants.font);
                g.drawString(this.tdata.cols[n].filter, (int)x + 5, h - 7);
            }
            x = ce;
        }
        boolean clicked = nc == this.clickCol;
        BaseXLayout.drawCell(g, (int)x, w + 16, 0, hh, clicked && this.header);
        BaseXLayout.drawCell(g, (int)x, w + 16, hh - 1, h, clicked && !this.header);
        g.setColor(Color.black);
        g.setFont(GUIConstants.bfont);
        TableHeader.smooth(g);
        int o = this.header && clicked ? 1 : 0;
        g.fillPolygon(new int[]{(int)x + o + 4, (int)x + o + 16 - 4, (int)x + o + 8}, new int[]{o + 6, o + 6, o + 16 - 3}, 3);
        o = !this.header && clicked ? 1 : 0;
        byte[] reset = new byte[]{120};
        BaseXLayout.chopString(g, reset, (int)(x += (double)(16 - BaseXLayout.width(g, reset)) / 2.0) + o, hh + o + 1, w, fsz);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.tdata.rows == null) {
            return;
        }
        Cursor cursor = GUIConstants.CURSORARROW;
        this.mouseX = e.getX();
        int w = this.getWidth() - 16;
        if (this.header(e.getY())) {
            this.moveC = this.colSep(w, this.mouseX);
            if (this.moveC != -1) {
                cursor = GUIConstants.CURSORMOVEH;
            }
        } else {
            int c;
            this.moveC = -1;
            if (this.mouseX < w) {
                cursor = GUIConstants.CURSORTEXT;
            }
            if (this.gui.gopts.get(GUIOptions.MOUSEFOCUS).booleanValue() && (c = this.tdata.column(w, this.mouseX)) != -1) {
                this.filter(c);
            }
        }
        this.view.gui.cursor(cursor);
    }

    private int colSep(int w, int mx) {
        double x = 0.0;
        for (int i = 0; i < this.tdata.cols.length; ++i) {
            if (i > 0 && Math.abs((double)mx - x) < 3.0) {
                return i;
            }
            x += (double)w * this.tdata.cols[i].width;
        }
        return -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.tdata.rows == null) {
            return;
        }
        if (this.moveC != -1) {
            int x = e.getX();
            double p = (double)(x - this.mouseX) / (double)(this.getWidth() - 16);
            double[] ww = new double[this.tdata.cols.length];
            for (int w = 0; w < ww.length; ++w) {
                ww[w] = this.tdata.cols[w].width;
            }
            if (e.isShiftDown()) {
                int n = this.moveC - 1;
                ww[n] = ww[n] + p;
                int n2 = this.moveC;
                ww[n2] = ww[n2] - p;
            } else {
                int i = 0;
                while (i < this.moveC) {
                    int n = i++;
                    ww[n] = ww[n] + p / (double)this.moveC;
                }
                i = this.moveC;
                while (i < ww.length) {
                    int n = i++;
                    ww[n] = ww[n] - p / (double)(ww.length - this.moveC);
                }
            }
            for (double w : ww) {
                if (!(w < 1.0E-4)) continue;
                return;
            }
            this.mouseX = x;
            for (int w = 0; w < ww.length; ++w) {
                this.tdata.cols[w].width = ww[w];
            }
        } else if (this.clickCol != -1) {
            int c = this.tdata.column(this.getWidth() - 16, e.getX());
            if (c == -1) {
                c = this.tdata.cols.length;
            }
            if (c != this.clickCol || this.header != this.header(e.getY())) {
                this.clickCol = -1;
            }
        }
        this.view.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.tdata.rows == null) {
            return;
        }
        this.view.gui.cursor(GUIConstants.CURSORARROW);
        this.clickCol = -1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.tdata.rows == null || !SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.clickCol = this.tdata.column(this.getWidth() - 16, this.mouseX);
        if (this.clickCol == -1) {
            this.clickCol = this.tdata.cols.length;
        }
        this.header = this.header(e.getY());
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.tdata.rows == null) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.clickCol == -1) {
                return;
            }
            if (this.header(e.getY())) {
                if (this.moveC == -1) {
                    if (this.clickCol == this.tdata.cols.length) {
                        this.chooseRoot(e);
                    } else {
                        this.view.gui.cursor(GUIConstants.CURSORWAIT);
                        this.tdata.asc = this.tdata.sortCol != this.clickCol || !this.tdata.asc;
                        this.tdata.sortCol = this.clickCol;
                        this.tdata.sort();
                        this.view.gui.cursor(GUIConstants.CURSORARROW, true);
                    }
                }
            } else if (this.clickCol == this.tdata.cols.length) {
                this.tdata.resetFilter();
                this.view.query();
            } else {
                this.filter(this.clickCol);
            }
        } else {
            this.chooseCols(e);
        }
        this.clickCol = -1;
        this.view.repaint();
    }

    private void chooseRoot(MouseEvent e) {
        if (this.tdata.roots.isEmpty()) {
            return;
        }
        final Data data = this.view.gui.context.data();
        JPopupMenu popup = new JPopupMenu();
        byte[] root = data.tagindex.key(this.tdata.root);
        for (byte[] en : this.tdata.roots) {
            final int id = data.tagindex.id(en);
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(Token.string(en), Token.eq(root, en));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ac) {
                    TableHeader.this.tdata.init(data, id);
                    TableHeader.this.view.refreshContext(true, false);
                }
            });
            popup.add(mi);
        }
        popup.show(this, e.getX(), e.getY());
    }

    private void chooseCols(MouseEvent e) {
        final JPopupMenu popup = new JPopupMenu();
        for (final TableData.TableCol col : this.tdata.cols) {
            String item = (col.elem ? "" : "@") + Token.string(col.name);
            final JCheckBoxMenuItem mi = new JCheckBoxMenuItem(item, col.width != 0.0);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ac) {
                    boolean sel;
                    boolean vis = sel = mi.isSelected();
                    for (TableData.TableCol c : ((TableHeader)TableHeader.this).tdata.cols) {
                        vis |= c != col && c.width != 0.0;
                    }
                    if (vis) {
                        col.hwidth = sel ? 0.0 : col.width;
                        col.width = sel ? col.hwidth : 0.0;
                    } else {
                        mi.setSelected(true);
                    }
                    popup.setVisible(true);
                    TableHeader.this.tdata.setWidths(true);
                    TableHeader.this.view.refreshContext(true, true);
                }
            });
            popup.add(mi);
        }
        popup.show(this, e.getX(), e.getY());
    }

    private boolean header(int y) {
        return y < this.getHeight() >> 1;
    }

    void filter(int col) {
        if (this.inputCol != col && this.tdata.cols.length != 0) {
            if (this.box != null) {
                this.box.stop();
            }
            this.box = new TableInput(this, this.tdata.cols[col].filter);
            this.inputCol = col;
        }
        this.requestFocusInWindow();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.tdata.roots.isEmpty() || this.box == null || BaseXKeys.control(e) || this.inputCol == -1) {
            return;
        }
        if (BaseXKeys.ENTER.is(e)) {
            this.box.stop();
            this.inputCol = -1;
            Nodes marked = this.view.gui.context.marked;
            if (marked.size() != 0L) {
                this.view.gui.notify.context(marked, false, null);
            }
        } else if (BaseXKeys.TAB.is(e)) {
            this.tdata.cols[this.inputCol].filter = this.box.text;
            this.box.stop();
            int in = this.inputCol + (e.isShiftDown() ? -1 : 1);
            if (in < 0) {
                this.transferFocusBackward();
            } else if (in == this.tdata.cols.length) {
                this.transferFocus();
            } else {
                this.inputCol = in;
                this.box = new TableInput(this, this.tdata.cols[this.inputCol].filter);
            }
        } else {
            this.box.code(e);
        }
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.tdata.roots.isEmpty() || this.box == null || this.inputCol == -1 || BaseXKeys.control(e) || !this.box.add(e)) {
            return;
        }
        this.tdata.cols[this.inputCol].filter = this.box.text;
        this.view.query();
    }
}

