/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.in.BufferInput;
import org.basex.util.Base64;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class IOUrl
extends IO {
    private static final String AUTHORIZATION = "Authorization";
    private static final int TIMEOUT = 10;

    public IOUrl(String u) {
        super(u);
    }

    @Override
    public byte[] read() throws IOException {
        return new BufferInput(this).content();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.path);
    }

    @Override
    public StreamSource streamSource() {
        return new StreamSource(this.path);
    }

    @Override
    public InputStream inputStream() throws IOException {
        URLConnection conn = null;
        try {
            conn = this.connection();
            return conn.getInputStream();
        }
        catch (IOException ex) {
            byte[] err;
            InputStream es;
            TokenBuilder msg = new TokenBuilder(Util.message(ex));
            if (conn instanceof HttpURLConnection && (es = ((HttpURLConnection)conn).getErrorStream()) != null && (err = new IOStream(es).read()).length != 0) {
                msg.add(Text.NL).add(Text.INFORMATION).add(":").add(Text.NL).add(err);
            }
            IOException io = new IOException(msg.toString());
            io.setStackTrace(ex.getStackTrace());
            throw io;
        }
        catch (RuntimeException ex) {
            Util.debug(ex);
            throw new BaseXException(Text.NOT_PARSED_X, this.path);
        }
    }

    public URLConnection connection() throws IOException {
        URL url = new URL(this.path);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        String ui = url.getUserInfo();
        if (ui != null) {
            conn.setRequestProperty(AUTHORIZATION, "Basic " + Base64.encode(ui));
        }
        return conn;
    }

    @Override
    public String dirPath() {
        return this.path.endsWith("/") ? this.path : this.path.substring(0, this.path.lastIndexOf(47) + 1);
    }

    @Override
    public IO merge(String f) {
        IO io = IO.get(f);
        if (!(io instanceof IOFile) || f.contains(":") || f.startsWith("/")) {
            return io;
        }
        return IO.get((this.path.endsWith("/") ? this.path : this.path.replace("^(.*/).*", "$1")) + f);
    }

    static boolean isValid(String url) {
        char c;
        int u = -1;
        int us = url.length();
        while (++u < us && (Token.letterOrDigit(c = url.charAt(u)) || c == '+' || c == '-' || c == '.')) {
        }
        return u > 2 && u + 1 < us && url.charAt(u) == ':' && url.charAt(u + 1) == '/';
    }

    public static boolean isFileURL(String s) {
        return s.startsWith("file:/");
    }
}

