/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.util.Stack;
import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryIOException;
import org.basex.query.util.Err;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTxt;
import org.basex.util.Util;
import org.basex.util.XMLToken;

public class JsonMLConverter
extends JsonXmlConverter {
    private final Stack<FElem> stack = new Stack();
    private byte[] attName;

    public JsonMLConverter(JsonParserOptions opts) {
        super(opts);
    }

    @Override
    public FDoc finish() {
        return new FDoc().add(this.stack.pop());
    }

    private static void error(String msg, Object ... ext) throws QueryIOException {
        throw Err.BXJS_PARSEML.getIO(new Object[]{Util.inf(msg, ext)});
    }

    byte[] check(byte[] name) throws QueryIOException {
        if (!XMLToken.isNCName(name)) {
            JsonMLConverter.error("Invalid name: \"%\"", new Object[]{name});
        }
        return name;
    }

    @Override
    public void openObject() throws QueryIOException {
        if (this.elem == null || this.attName != null || this.stack.peek() != null) {
            JsonMLConverter.error("No object allowed at this stage", new Object[0]);
        }
    }

    @Override
    public void openPair(byte[] key) throws QueryIOException {
        this.attName = this.check(key);
    }

    @Override
    public void closePair() throws QueryIOException {
    }

    @Override
    public void closeObject() {
        this.stack.pop();
        this.stack.push(this.elem);
        this.elem = null;
    }

    @Override
    public void openArray() throws QueryIOException {
        if (!this.stack.isEmpty()) {
            if (this.attName == null && this.elem != null && this.stack.peek() == null) {
                this.stack.pop();
                this.stack.push(this.elem);
                this.elem = null;
            } else if (this.attName != null || this.elem != null || this.stack.peek() == null) {
                JsonMLConverter.error("No array allowed at this stage", new Object[0]);
            }
        }
        this.stack.push(null);
        this.elem = null;
    }

    @Override
    public void openItem() {
    }

    @Override
    public void closeItem() throws QueryIOException {
    }

    @Override
    public void closeArray() throws QueryIOException {
        FElem val = this.stack.pop();
        if (val == null) {
            val = this.elem;
            this.elem = null;
        }
        if (val == null) {
            JsonMLConverter.error("Missing element name", new Object[0]);
        }
        if (this.stack.isEmpty()) {
            this.stack.push(val);
        } else {
            this.stack.peek().add(val);
        }
    }

    @Override
    public void stringLit(byte[] val) throws QueryIOException {
        if (this.attName == null && this.elem != null && this.stack.peek() == null) {
            this.stack.pop();
            this.stack.push(this.elem);
            this.elem = null;
        }
        if (this.elem == null) {
            FElem e;
            FElem fElem = e = this.stack.isEmpty() ? null : this.stack.peek();
            if (e == null) {
                this.elem = new FElem(this.check(val));
            } else {
                e.add(new FTxt(val));
            }
        } else if (this.attName != null) {
            this.elem.add(this.attName, val);
            this.attName = null;
        } else {
            JsonMLConverter.error("No string allowed at this stage", new Object[0]);
        }
    }

    @Override
    public void numberLit(byte[] value) throws QueryIOException {
        JsonMLConverter.error("No numbers allowed", new Object[0]);
    }

    @Override
    public void nullLit() throws QueryIOException {
        JsonMLConverter.error("No 'null' allowed", new Object[0]);
    }

    @Override
    public void booleanLit(byte[] b) throws QueryIOException {
        JsonMLConverter.error("No booleans allowed", new Object[0]);
    }

    @Override
    public void openConstr(byte[] nm) throws QueryIOException {
        JsonMLConverter.error("No constructor functions allowed", new Object[0]);
    }

    @Override
    public void openArg() {
    }

    @Override
    public void closeArg() throws QueryIOException {
    }

    @Override
    public void closeConstr() throws QueryIOException {
    }
}

