/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.util.Stack;
import org.basex.build.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.seq.Empty;
import org.basex.util.Token;

public final class JsonMapConverter
extends JsonConverter {
    private final Stack<Value> stack = new Stack();

    public JsonMapConverter(JsonParserOptions opts) {
        super(opts);
    }

    @Override
    public Item finish() {
        return this.stack.peek().isEmpty() ? null : (Item)this.stack.pop();
    }

    @Override
    void openObject() {
        this.stack.push(Map.EMPTY);
    }

    @Override
    void openPair(byte[] key) {
        this.stack.push(Str.get(key));
    }

    @Override
    void closePair() throws QueryIOException {
        Value val = this.stack.pop();
        Item key = (Item)this.stack.pop();
        Map map = (Map)this.stack.pop();
        try {
            this.stack.push(map.insert(key, val, null));
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }

    @Override
    void closeObject() {
    }

    @Override
    void openArray() {
        this.stack.push(Map.EMPTY);
    }

    @Override
    void openItem() {
        this.stack.push(Int.get(((Map)this.stack.peek()).mapSize() + 1));
    }

    @Override
    void closeItem() throws QueryIOException {
        this.closePair();
    }

    @Override
    void closeArray() {
    }

    @Override
    public void openConstr(byte[] name) {
        this.openObject();
        this.openPair(name);
        this.openArray();
    }

    @Override
    public void openArg() {
        this.openItem();
    }

    @Override
    public void closeArg() throws QueryIOException {
        this.closeItem();
    }

    @Override
    public void closeConstr() throws QueryIOException {
        this.closeArray();
        this.closePair();
        this.closeObject();
    }

    @Override
    public void numberLit(byte[] val) throws QueryIOException {
        try {
            this.stack.push(Dbl.get(val, null));
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }

    @Override
    public void stringLit(byte[] value) {
        this.stack.push(Str.get(value));
    }

    @Override
    public void nullLit() {
        this.stack.push(Empty.SEQ);
    }

    @Override
    public void booleanLit(byte[] b) {
        this.stack.push(Bln.get(Token.eq(b, Token.TRUE)));
    }
}

