/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlParser {
    final XMLReader reader;

    public XmlParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
        this.reader = factory.newSAXParser().getXMLReader();
    }

    public XmlParser contentHandler(ContentHandler handler) {
        this.reader.setContentHandler(handler);
        return this;
    }

    public void parse(InputStream stream) throws IOException, SAXException {
        this.reader.setErrorHandler(new ErrorHandler());
        this.reader.parse(new InputSource(stream));
    }

    private static class ErrorHandler
    extends DefaultHandler {
        private ErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXParseException {
            throw ex;
        }

        @Override
        public void error(SAXParseException ex) throws SAXParseException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXParseException {
            throw ex;
        }
    }
}

