/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.data.ExprInfo;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public class QueryException
extends Exception {
    private final ArrayList<InputInfo> stack = new ArrayList();
    private final QNm name;
    private Value value = Empty.SEQ;
    private Err err;
    private StringList suggest;
    private InputInfo info;
    private int markedCol;
    private boolean catchable = true;

    public QueryException(Throwable th) {
        this(Util.message(th));
    }

    public QueryException(String msg) {
        this(null, Err.BASX_GENERIC, msg);
    }

    public QueryException(InputInfo ii, Err er, Object ... ext) {
        this(ii, er.qname(), er.desc, ext);
        this.err = er;
    }

    public QueryException(InputInfo ii, QNm errc, String msg, Object ... ext) {
        super(QueryException.message(msg, ext));
        this.name = errc;
        if (ii != null) {
            this.info(ii);
        }
        for (Object o : ext) {
            if (!(o instanceof Throwable)) continue;
            this.initCause((Throwable)o);
            break;
        }
    }

    public int column() {
        return this.info == null ? 0 : this.info.column();
    }

    public int markedColumn() {
        return this.markedCol;
    }

    public int line() {
        return this.info == null ? 0 : this.info.line();
    }

    public String file() {
        return this.info == null ? null : this.info.path();
    }

    public StringList suggest() {
        return this.suggest == null ? new StringList() : this.suggest;
    }

    public QueryException suggest(InputParser qp, StringList sug) {
        this.suggest = sug;
        this.pos(qp);
        return this;
    }

    public void add(InputInfo ii) {
        if (ii != null) {
            this.stack.add(ii);
        }
    }

    public QueryException info(InputInfo ii) {
        this.info = ii;
        return this;
    }

    public InputInfo info() {
        return this.info;
    }

    public QueryException value(Value v) {
        this.value = v;
        return this;
    }

    public QueryException err(Err e) {
        this.err = e;
        return this;
    }

    void pos(InputParser parser) {
        this.markedCol = parser.mark;
        if (this.info != null) {
            return;
        }
        parser.pos = Math.min(parser.mark, parser.length);
        this.info = new InputInfo(parser);
    }

    public QNm qname() {
        return this.name;
    }

    public Err err() {
        return this.err;
    }

    public Value value() {
        return this.value;
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        byte[] code;
        TokenBuilder tb = new TokenBuilder();
        if (this.info != null) {
            tb.add(Text.STOPPED_AT).add(this.info.toString()).add(":").add(Text.NL);
        }
        if ((code = this.name.local()).length != 0) {
            tb.add(91).add(code).add("] ");
        }
        tb.add(this.getLocalizedMessage());
        if (!this.stack.isEmpty()) {
            tb.add(Text.NL).add(Text.NL).add("Stack Trace").add(":");
            for (InputInfo ii : this.stack) {
                tb.add(Text.NL).add("- ").add(ii.toString());
            }
        }
        return tb.toString();
    }

    public boolean isCatchable() {
        return this.catchable;
    }

    public QueryException notCatchable() {
        this.catchable = false;
        return this;
    }

    private static String message(String text, Object[] ext) {
        int es = ext.length;
        for (int e = 0; e < es; ++e) {
            Object o = ext[e];
            if (o instanceof byte[]) {
                o = Token.string((byte[])o);
            } else if (o instanceof ExprInfo) {
                o = ((ExprInfo)o).toErrorString();
            } else if (o instanceof Throwable) {
                o = Util.message((Throwable)o);
            } else if (!(o instanceof String)) {
                o = String.valueOf(o);
            }
            ext[e] = o;
        }
        return Util.info(text, ext);
    }
}

