/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.Expr;
import org.basex.query.expr.InterSect;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pos;
import org.basex.query.func.Function;
import org.basex.query.util.ExprList;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class And
extends Logical {
    public And(InputInfo ii, Expr ... e) {
        super(ii, e);
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        Expr c = super.compile(ctx, scp);
        return c != this ? c : this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        int es = this.expr.length;
        ExprList el = new ExprList(es);
        Pos ps = null;
        CmpR cr = null;
        CmpSR cs = null;
        for (Expr e : this.expr) {
            Expr tmp = null;
            if (e instanceof Pos) {
                Expr expr = tmp = ps == null ? e : ps.intersect((Pos)e, this.info);
                if (!(tmp instanceof Pos)) {
                    return tmp;
                }
                ps = (Pos)tmp;
            } else if (e instanceof CmpR) {
                Expr expr = tmp = cr == null ? e : cr.intersect((CmpR)e);
                if (tmp instanceof CmpR) {
                    cr = (CmpR)tmp;
                } else if (tmp != null) {
                    return tmp;
                }
            } else if (e instanceof CmpSR) {
                Expr expr = tmp = cs == null ? e : cs.intersect((CmpSR)e);
                if (tmp instanceof CmpSR) {
                    cs = (CmpSR)tmp;
                } else if (tmp != null) {
                    return tmp;
                }
            }
            if (tmp != null || e == Bln.TRUE) continue;
            if (e == Bln.FALSE) {
                return this.optPre(Bln.FALSE, ctx);
            }
            el.add(e);
        }
        if (ps != null) {
            el.add(ps);
        }
        if (cr != null) {
            el.add(cr);
        }
        if (cs != null) {
            el.add(cs);
        }
        if (el.size() == 0) {
            return this.optPre(Bln.TRUE, ctx);
        }
        if (es != el.size()) {
            ctx.compInfo("rewriting %", this);
        }
        this.expr = el.finish();
        this.compFlatten(ctx);
        boolean not = true;
        for (Expr e : this.expr) {
            if (e.isFunction(Function.NOT)) continue;
            not = false;
            break;
        }
        if (not) {
            ctx.compInfo("rewriting %", this);
            Expr[] inner = new Expr[this.expr.length];
            for (int i = 0; i < inner.length; ++i) {
                inner[i] = ((Arr)this.expr[i]).expr[0];
            }
            Expr or = new Or(this.info, inner).optimize(ctx, scp);
            return Function.NOT.get(null, or).optimize(ctx, scp);
        }
        return this.expr.length == 1 ? And.compBln(this.expr[0], this.info) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        for (int i = 0; i < this.expr.length - 1; ++i) {
            if (this.expr[i].ebv(ctx, this.info).bool(this.info)) continue;
            return Bln.FALSE;
        }
        Expr last = this.expr[this.expr.length - 1];
        return this.tailCall ? last.item(ctx, ii) : (last.ebv(ctx, ii).bool(ii) ? Bln.TRUE : Bln.FALSE);
    }

    @Override
    public And copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vars) {
        int es = this.expr.length;
        Expr[] ex = new Expr[es];
        for (int i = 0; i < es; ++i) {
            ex[i] = this.expr[i].copy(ctx, scp, vars);
        }
        return new And(this.info, ex);
    }

    @Override
    public boolean indexAccessible(IndexCosts ic) throws QueryException {
        int is = 0;
        int es = this.expr.length;
        int[] ics = new int[es];
        boolean ia = true;
        for (int e = 0; e < es; ++e) {
            if (this.expr[e].indexAccessible(ic) && !ic.seq) {
                if (ic.costs() == 0) {
                    return true;
                }
                ics[e] = ic.costs();
                if (is != 0 && ic.costs() >= is) continue;
                is = ic.costs();
                continue;
            }
            ia = false;
        }
        if (ia) {
            int[] ord = Array.createOrder(ics, true);
            Expr[] ex = new Expr[es];
            for (int e = 0; e < es; ++e) {
                ex[e] = this.expr[ord[e]];
            }
            this.expr = ex;
        }
        ic.costs(is);
        return ia;
    }

    @Override
    public Expr indexEquivalent(IndexCosts ic) throws QueryException {
        super.indexEquivalent(ic);
        return new InterSect(this.info, this.expr);
    }

    @Override
    public String toString() {
        return this.toString(" and ");
    }
}

