/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.BitSet;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.IndexCosts;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Expr
extends ExprInfo {
    public abstract void checkUp() throws QueryException;

    public abstract Expr compile(QueryContext var1, VarScope var2) throws QueryException;

    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        return this;
    }

    public abstract Iter iter(QueryContext var1) throws QueryException;

    public abstract Item item(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Value value(QueryContext var1) throws QueryException;

    public abstract Item ebv(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Item test(QueryContext var1, InputInfo var2) throws QueryException;

    public boolean isEmpty() {
        return false;
    }

    public boolean isVacuous() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isItem() {
        return false;
    }

    public abstract long size();

    public abstract boolean has(Flag var1);

    public final boolean uses(final Var v) {
        return !this.accept(new ASTVisitor(){

            @Override
            public boolean used(VarRef ref) {
                return !ref.var.is(v);
            }
        });
    }

    public abstract boolean removable(Var var1);

    public abstract VarUsage count(Var var1);

    public abstract Expr inline(QueryContext var1, VarScope var2, Var var3, Expr var4) throws QueryException;

    protected static boolean inlineAll(QueryContext ctx, VarScope scp, Expr[] arr, Var v, Expr e) throws QueryException {
        boolean change = false;
        for (int i = 0; i < arr.length; ++i) {
            Expr nw = arr[i].inline(ctx, scp, v, e);
            if (nw == null) continue;
            arr[i] = nw;
            change = true;
        }
        return change;
    }

    public final Expr copy(QueryContext ctx, VarScope scp) {
        return this.copy(ctx, scp, new IntObjMap<Var>());
    }

    public abstract Expr copy(QueryContext var1, VarScope var2, IntObjMap<Var> var3);

    public Expr compEbv(QueryContext ctx) {
        return this;
    }

    public abstract SeqType type();

    public boolean iterable() {
        return this.type().zeroOrOne();
    }

    public boolean indexAccessible(IndexCosts ic) throws QueryException {
        return false;
    }

    public Expr indexEquivalent(IndexCosts ic) throws QueryException {
        return null;
    }

    public boolean sameAs(Expr cmp) {
        return this == cmp;
    }

    public boolean isFunction(Function f) {
        return false;
    }

    public Expr addText(QueryContext ctx) {
        return this;
    }

    public boolean hasFreeVars() {
        final BitSet declared = new BitSet();
        return !this.accept(new ASTVisitor(){

            @Override
            public boolean declared(Var var) {
                declared.set(var.id);
                return true;
            }

            @Override
            public boolean used(VarRef ref) {
                return declared.get(ref.var.id);
            }
        });
    }

    public void markTailCalls(QueryContext ctx) {
    }

    public abstract boolean accept(ASTVisitor var1);

    protected static boolean visitAll(ASTVisitor visitor, Expr ... exprs) {
        for (Expr e : exprs) {
            if (e.accept(visitor)) continue;
            return false;
        }
        return true;
    }

    public abstract int exprSize();

    protected Expr typeCheck(TypeCheck tc, QueryContext ctx, VarScope scp) throws QueryException {
        return null;
    }

    public static enum Flag {
        CNS,
        CTX,
        NDT,
        FCS,
        UPD,
        X30,
        HOF;

    }
}

