/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNInfo;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class SwitchCase
extends Arr {
    public SwitchCase(InputInfo ii, Expr ... e) {
        super(ii, e);
    }

    @Override
    public void checkUp() throws QueryException {
        int es = this.expr.length;
        for (int e = 1; e < es; ++e) {
            this.checkNoUp(this.expr[e]);
        }
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) {
        int es = this.expr.length;
        for (int e = 0; e < es; ++e) {
            try {
                this.expr[e] = this.expr[e].compile(ctx, scp);
                continue;
            }
            catch (QueryException ex) {
                this.expr[e] = FNInfo.error(ex, this.expr[e].type());
            }
        }
        return this;
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new SwitchCase(this.info, SwitchCase.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr));
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        boolean change = false;
        int es = this.expr.length;
        for (int i = 0; i < es; ++i) {
            Expr nw;
            try {
                nw = this.expr[i].inline(ctx, scp, v, e);
            }
            catch (QueryException qe) {
                nw = FNInfo.error(qe, this.expr[i].type());
            }
            if (nw == null) continue;
            this.expr[i] = nw;
            change = true;
        }
        return change ? this.optimize(ctx, scp) : null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int es = this.expr.length;
        for (int e = 1; e < es; ++e) {
            sb.append(" case " + this.expr[e]);
        }
        if (es == 1) {
            sb.append(" default");
        }
        sb.append(" return " + this.expr[0]);
        return sb.toString();
    }

    @Override
    public VarUsage count(Var v) {
        return this.expr[0].count(v);
    }

    VarUsage countCases(Var v) {
        VarUsage all = VarUsage.NEVER;
        int es = this.expr.length;
        for (int i = 1; i < es && (all = all.plus(this.expr[i].count(v))) != VarUsage.MORE_THAN_ONCE; ++i) {
        }
        return all;
    }

    @Override
    public int exprSize() {
        int sz = 0;
        for (Expr e : this.expr) {
            sz += e.exprSize();
        }
        return sz;
    }
}

