/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjMap;

public final class TypeCheck
extends Single {
    public final boolean promote;
    private final StaticContext sc;

    public TypeCheck(StaticContext sctx, InputInfo ii, Expr e, SeqType to, boolean f) {
        super(ii, e);
        this.sc = sctx;
        this.type = to;
        this.promote = f;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        this.expr = this.expr.compile(ctx, scp);
        return this.optimize(ctx, scp);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        SeqType.Occ occ;
        SeqType argType = this.expr.type();
        if (argType.instanceOf(this.type)) {
            ctx.compInfo("removing redundant % cast.", this.type);
            return this.expr;
        }
        if (this.expr.isValue()) {
            if (this.expr instanceof FuncItem && this.type.type instanceof FuncType) {
                if (!this.type.occ.check(1L)) {
                    throw Err.treatError(this.info, this.type, this.expr);
                }
                FuncItem fit = (FuncItem)this.expr;
                return this.optPre(fit.coerceTo((FuncType)this.type.type, ctx, this.info, true), ctx);
            }
            return this.optPre(this.value(ctx), ctx);
        }
        if (argType.type.instanceOf(this.type.type) && (occ = argType.occ.intersect(this.type.occ)) == null) {
            throw Err.INVCAST.get(this.info, argType, this.type);
        }
        Expr opt = this.expr.typeCheck(this, ctx, scp);
        if (opt != null) {
            return this.optPre(opt, ctx);
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        Value val = this.expr.value(ctx);
        if (this.type.instance(val)) {
            return val;
        }
        if (this.promote) {
            return this.type.promote(ctx, this.sc, this.info, val, false);
        }
        throw Err.INVCAST.get(this.info, val.type(), this.type);
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new TypeCheck(this.sc, this.info, this.expr.copy(ctx, scp, vs), this.type, this.promote);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(QueryText.TYP, this.type);
        if (this.promote) {
            elem.add(this.planAttr("function", Token.TRUE));
        }
        this.addPlan(plan, elem, this.expr);
    }

    @Override
    public String toString() {
        return "((: " + this.type + ", " + this.promote + " :) " + this.expr.toString() + ')';
    }

    public boolean isRedundant(Var var) {
        return (!this.promote || var.promotes()) && var.declaredType().instanceOf(this.type);
    }

    public Expr check(Expr e, QueryContext ctx, VarScope scp) throws QueryException {
        return new TypeCheck(this.sc, this.info, e, this.type, this.promote).optimize(ctx, scp);
    }
}

