/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNAcc
extends StandardFunc {
    public FNAcc(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr.length == 0 ? this.checkCtx(ctx) : this.expr[0];
        switch (this.sig) {
            case POSITION: {
                return Int.get(ctx.pos);
            }
            case LAST: {
                return Int.get(ctx.size);
            }
            case STRING: {
                return this.string(e, ii, ctx);
            }
            case NUMBER: {
                return this.number(ctx.iter(e), ctx);
            }
            case STRING_LENGTH: {
                return Int.get(Token.len(this.checkEStr(this.expr.length == 0 ? this.string(e, ii, ctx) : e, ctx)));
            }
            case NORMALIZE_SPACE: {
                return Str.get(Token.norm(this.checkEStr(e, ctx)));
            }
            case NAMESPACE_URI_FROM_QNAME: {
                Item it = e.item(ctx, this.info);
                return it == null ? null : Uri.uri(this.checkQNm(it, ctx, this.sc).uri());
            }
        }
        return super.item(ctx, ii);
    }

    private Item string(Expr e, InputInfo ii, QueryContext ctx) throws QueryException {
        Item it = e.item(ctx, this.info);
        if (it == null) {
            return Str.ZERO;
        }
        if (it instanceof FItem) {
            throw Err.FISTR.get(ii, it.type);
        }
        return it.type == AtomType.STR ? it : Str.get(it.string(ii));
    }

    private Item number(Iter ir, QueryContext ctx) throws QueryException {
        Item it = ir.next();
        if (it == null || ir.next() != null) {
            return Dbl.NAN;
        }
        if (it instanceof FItem) {
            throw Err.FIATOM.get(this.info, it.type);
        }
        try {
            return it.type == AtomType.DBL ? it : AtomType.DBL.cast(it, ctx, this.sc, this.info);
        }
        catch (QueryException ex) {
            return Dbl.NAN;
        }
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.CTX && this.expr.length == 0 || super.has(flag);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return (FNAcc.oneOf(this.sig, Function.POSITION, Function.LAST) || this.expr.length != 0 || visitor.lock("%CTX")) && super.accept(visitor);
    }
}

