/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.basex.core.MainOptions;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.type.AtomType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public final class FNConvert
extends StandardFunc {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final BigInteger MAX_ULONG = BigInteger.ONE.shiftLeft(64);

    public FNConvert(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _CONVERT_BINARY_TO_BYTES: {
                return this.binaryToBytes(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _CONVERT_BINARY_TO_BYTES: {
                return this.binaryToBytes(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _CONVERT_INTEGER_FROM_BASE: {
                return this.integerFromBase(ctx, ii);
            }
            case _CONVERT_INTEGER_TO_BASE: {
                return this.integerToBase(ctx, ii);
            }
            case _CONVERT_BINARY_TO_STRING: {
                return this.toString(ctx);
            }
            case _CONVERT_STRING_TO_BASE64: {
                return new B64(this.stringToBinary(ctx));
            }
            case _CONVERT_BYTES_TO_BASE64: {
                return new B64(this.bytesToBinary(ctx));
            }
            case _CONVERT_STRING_TO_HEX: {
                return new Hex(this.stringToBinary(ctx));
            }
            case _CONVERT_BYTES_TO_HEX: {
                return new Hex(this.bytesToBinary(ctx));
            }
            case _CONVERT_DATETIME_TO_INTEGER: {
                return this.dateTimeToInteger(ctx);
            }
            case _CONVERT_INTEGER_TO_DATETIME: {
                return this.integerToDateTime(ctx);
            }
            case _CONVERT_DAYTIME_TO_INTEGER: {
                return this.dayTimeToInteger(ctx);
            }
            case _CONVERT_INTEGER_TO_DAYTIME: {
                return this.integerToDayTime(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private static Str toBaseFast(long num, int shift) {
        byte[] bytes = new byte[(64 + shift - 1) / shift];
        int mask = (1 << shift) - 1;
        long n = num;
        int pos = bytes.length;
        do {
            bytes[--pos] = DIGITS[(int)(n & (long)mask)];
        } while ((n >>>= shift) != 0L);
        return Str.get(Token.substring(bytes, pos));
    }

    private Str integerToBase(QueryContext ctx, InputInfo ii) throws QueryException {
        long num = this.checkItr(this.expr[0], ctx);
        long base = this.checkItr(this.expr[1], ctx);
        if (base < 2L || base > 36L) {
            throw Err.INVBASE.get(ii, base);
        }
        int i = 1;
        int p = 2;
        while (i < 6) {
            if (base == (long)p) {
                return FNConvert.toBaseFast(num, i);
            }
            ++i;
            p <<= 1;
        }
        ByteList tb = new ByteList();
        long n = num;
        if (n < 0L) {
            BigInteger[] dr = BigInteger.valueOf(n).add(MAX_ULONG).divideAndRemainder(BigInteger.valueOf(base));
            n = dr[0].longValue();
            tb.add(DIGITS[dr[1].intValue()]);
        } else {
            tb.add(DIGITS[(int)(n % base)]);
            n /= base;
        }
        while (n != 0L) {
            tb.add(DIGITS[(int)(n % base)]);
            n /= base;
        }
        byte[] res = tb.toArray();
        Array.reverse(res);
        return Str.get(res);
    }

    private Int integerFromBase(QueryContext ctx, InputInfo ii) throws QueryException {
        byte[] str = this.checkStr(this.expr[0], ctx);
        long base = this.checkItr(this.expr[1], ctx);
        if (base < 2L || base > 36L) {
            throw Err.INVBASE.get(ii, base);
        }
        long res = 0L;
        for (byte b : str) {
            int num;
            int n = num = b <= 57 ? b - 48 : (b & 0xDF) - 55;
            if (!((b >= 48 && b <= 57 || b >= 97 && b <= 122 || b >= 65 && b <= 90) && (long)num < base)) {
                throw Err.INVDIG.get(ii, base, Character.valueOf((char)(b & 0xFF)));
            }
            res = res * base + (long)num;
        }
        return Int.get(res);
    }

    private Value binaryToBytes(QueryContext ctx) throws QueryException {
        try {
            return BytSeq.get(this.checkItem(this.expr[0], ctx).input(this.info).content());
        }
        catch (IOException ex) {
            throw Err.BXCO_STRING.get(this.info, ex);
        }
    }

    private Dtm integerToDateTime(QueryContext ctx) throws QueryException {
        return new Dtm(this.checkItr(this.expr[0], ctx), this.info);
    }

    private Int dateTimeToInteger(QueryContext ctx) throws QueryException {
        return Int.get(this.dateTimeToMs(this.expr[0], ctx));
    }

    private DTDur integerToDayTime(QueryContext ctx) throws QueryException {
        return new DTDur(this.checkItr(this.expr[0], ctx));
    }

    private Int dayTimeToInteger(QueryContext ctx) throws QueryException {
        DTDur dur = (DTDur)this.checkType(this.checkItem(this.expr[0], ctx), AtomType.DTD);
        BigDecimal ms = dur.sec.multiply(BigDecimal.valueOf(1000L));
        if (ms.compareTo(ADateDur.BDMAXLONG) > 0) {
            throw Err.INTRANGE.get(this.info, dur);
        }
        return Int.get(ms.longValue());
    }

    private Str toString(QueryContext ctx) throws QueryException {
        Bin bin = this.checkBinary(this.expr[0], ctx);
        String enc = this.encoding(1, Err.BXCO_ENCODING, ctx);
        try {
            return Str.get(FNConvert.toString((InputStream)bin.input(this.info), enc, ctx));
        }
        catch (IOException ex) {
            throw Err.BXCO_STRING.get(this.info, ex);
        }
    }

    public static byte[] toString(InputStream is, String enc, QueryContext ctx) throws IOException {
        return FNConvert.toString(is, enc, ctx.context.options.get(MainOptions.CHECKSTRINGS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toString(InputStream is, String enc, boolean val) throws IOException {
        try {
            byte[] byArray = new TextInput(is).encoding(enc).validate(val).content();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    private byte[] stringToBinary(QueryContext ctx) throws QueryException {
        byte[] in = this.checkStr(this.expr[0], ctx);
        String enc = this.encoding(1, Err.BXCO_ENCODING, ctx);
        if (enc == null || enc == "UTF-8") {
            return in;
        }
        try {
            return FNConvert.toBinary(in, enc);
        }
        catch (CharacterCodingException ex) {
            throw Err.BXCO_BASE64.get(this.info, new Object[0]);
        }
    }

    public static byte[] toBinary(byte[] in, String enc) throws CharacterCodingException {
        if (enc == "UTF-8") {
            return in;
        }
        ByteBuffer bb = Charset.forName(enc).newEncoder().encode(CharBuffer.wrap(Token.string(in)));
        int il = bb.limit();
        byte[] tmp = bb.array();
        return tmp.length == il ? tmp : Arrays.copyOf(tmp, il);
    }

    private byte[] bytesToBinary(QueryContext ctx) throws QueryException {
        Item it;
        Value v = this.expr[0].value(ctx);
        if (v instanceof BytSeq) {
            return ((BytSeq)v).toJava();
        }
        ValueIter ir = v.iter();
        ByteList bl = new ByteList(Math.max(8, (int)v.size()));
        while ((it = ((Iter)ir).next()) != null) {
            bl.add((int)((ANum)this.checkType(it, AtomType.BYT)).itr());
        }
        return bl.toArray();
    }
}

