/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class FNDate
extends StandardFunc {
    public FNDate(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            return null;
        }
        switch (this.sig) {
            case YEARS_FROM_DURATION: {
                return Int.get(this.checkDur(it).yea());
            }
            case YEAR_FROM_DATETIME: {
                return Int.get(this.checkDate(it, AtomType.DTM, ctx).yea());
            }
            case YEAR_FROM_DATE: {
                return Int.get(this.checkDate(it, AtomType.DAT, ctx).yea());
            }
            case MONTHS_FROM_DURATION: {
                return Int.get(this.checkDur(it).mon());
            }
            case MONTH_FROM_DATETIME: {
                return Int.get(this.checkDate(it, AtomType.DTM, ctx).mon());
            }
            case MONTH_FROM_DATE: {
                return Int.get(this.checkDate(it, AtomType.DAT, ctx).mon());
            }
            case DAYS_FROM_DURATION: {
                return Int.get(this.checkDur(it).day());
            }
            case DAY_FROM_DATETIME: {
                return Int.get(this.checkDate(it, AtomType.DTM, ctx).day());
            }
            case DAY_FROM_DATE: {
                return Int.get(this.checkDate(it, AtomType.DAT, ctx).day());
            }
            case HOURS_FROM_DURATION: {
                return Int.get(this.checkDur(it).hou());
            }
            case HOURS_FROM_DATETIME: {
                return Int.get(this.checkDate(it, AtomType.DTM, ctx).hou());
            }
            case HOURS_FROM_TIME: {
                return Int.get(this.checkDate(it, AtomType.TIM, ctx).hou());
            }
            case MINUTES_FROM_DURATION: {
                return Int.get(this.checkDur(it).min());
            }
            case MINUTES_FROM_DATETIME: {
                return Int.get(this.checkDate(it, AtomType.DTM, ctx).min());
            }
            case MINUTES_FROM_TIME: {
                return Int.get(this.checkDate(it, AtomType.TIM, ctx).min());
            }
            case SECONDS_FROM_DURATION: {
                return Dec.get(this.checkDur(it).sec());
            }
            case SECONDS_FROM_DATETIME: {
                return Dec.get(this.checkDate(it, AtomType.DTM, ctx).sec());
            }
            case SECONDS_FROM_TIME: {
                return Dec.get(this.checkDate(it, AtomType.TIM, ctx).sec());
            }
            case TIMEZONE_FROM_DATETIME: {
                return FNDate.zon(this.checkDate(it, AtomType.DTM, ctx));
            }
            case TIMEZONE_FROM_DATE: {
                return FNDate.zon(this.checkDate(it, AtomType.DAT, ctx));
            }
            case TIMEZONE_FROM_TIME: {
                return FNDate.zon(this.checkDate(it, AtomType.TIM, ctx));
            }
            case ADJUST_DATE_TO_TIMEZONE: {
                return this.adjust(it, AtomType.DAT, ctx);
            }
            case ADJUST_DATETIME_TO_TIMEZONE: {
                return this.adjust(it, AtomType.DTM, ctx);
            }
            case ADJUST_TIME_TO_TIMEZONE: {
                return this.adjust(it, AtomType.TIM, ctx);
            }
            case DATETIME: {
                return this.dateTime(it, ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private static DTDur zon(ADate it) {
        int tz = it.zon();
        return tz == Short.MAX_VALUE ? null : new DTDur(0L, tz);
    }

    private ADate checkDate(Item it, Type t, QueryContext ctx) throws QueryException {
        return (ADate)(it.type.isUntyped() ? t.cast(it, ctx, this.sc, this.info) : this.checkType(it, t));
    }

    private Dur checkDur(Item it) throws QueryException {
        if (it instanceof Dur) {
            return (Dur)it;
        }
        if (it.type.isUntyped()) {
            return new Dur(it.string(this.info), this.info);
        }
        throw Err.typeError(this, AtomType.DUR, it);
    }

    private ADate dateTime(Item date, QueryContext ctx) throws QueryException {
        Item zon;
        Item item = zon = this.expr.length == 2 ? this.expr[1].item(ctx, this.info) : null;
        if (zon == null) {
            return null;
        }
        Dat d = date.type.isUntyped() ? new Dat(date.string(this.info), this.info) : (Dat)this.checkType(date, AtomType.DAT);
        Tim t = zon.type.isUntyped() ? new Tim(zon.string(this.info), this.info) : (Tim)this.checkType(zon, AtomType.TIM);
        return new Dtm(d, t, this.info);
    }

    private ADate adjust(Item it, Type t, QueryContext ctx) throws QueryException {
        ADate ad;
        if (it.type.isUntyped()) {
            ad = (ADate)t.cast(it, ctx, this.sc, this.info);
        } else {
            ADate a = (ADate)this.checkType(it, t);
            ad = t == AtomType.TIM ? new Tim(a) : (t == AtomType.DAT ? new Dat(a) : new Dtm(a));
        }
        boolean spec = this.expr.length == 2;
        Item zon = spec ? this.expr[1].item(ctx, this.info) : null;
        ad.timeZone(zon == null ? null : (DTDur)this.checkType(zon, AtomType.DTD), spec, this.info);
        return ad;
    }
}

