/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.regex.Pattern;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.random.DataAccess;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNGen;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.B64Stream;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.StrStream;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class FNFile
extends StandardFunc {
    private static final byte[] NL = Token.token(Prop.NL);

    public FNFile(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _FILE_LIST: {
                return this.list(ctx);
            }
            case _FILE_READ_TEXT_LINES: {
                return this.readTextLines(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        try {
            switch (this.sig) {
                case _FILE_APPEND: {
                    return this.write(true, ctx);
                }
                case _FILE_APPEND_BINARY: {
                    return this.writeBinary(true, ctx);
                }
                case _FILE_APPEND_TEXT: {
                    return this.writeText(true, ctx);
                }
                case _FILE_APPEND_TEXT_LINES: {
                    return this.writeTextLines(true, ctx);
                }
                case _FILE_NAME: {
                    return this.name(ctx);
                }
                case _FILE_COPY: {
                    return this.relocate(true, ctx);
                }
                case _FILE_CREATE_DIR: {
                    return this.createDir(ctx);
                }
                case _FILE_CREATE_TEMP_DIR: {
                    return this.createTemp(true, ctx);
                }
                case _FILE_CREATE_TEMP_FILE: {
                    return this.createTemp(false, ctx);
                }
                case _FILE_DELETE: {
                    return this.delete(ctx);
                }
                case _FILE_PARENT: {
                    return this.parent(ctx);
                }
                case _FILE_DIR_SEPARATOR: {
                    return Str.get(File.separator);
                }
                case _FILE_EXISTS: {
                    return Bln.get(this.checkFile(0, ctx).exists());
                }
                case _FILE_IS_DIR: {
                    return Bln.get(this.checkFile(0, ctx).isDirectory());
                }
                case _FILE_IS_FILE: {
                    return Bln.get(this.checkFile(0, ctx).isFile());
                }
                case _FILE_LAST_MODIFIED: {
                    return this.lastModified(ctx);
                }
                case _FILE_LINE_SEPARATOR: {
                    return Str.get(NL);
                }
                case _FILE_MOVE: {
                    return this.relocate(false, ctx);
                }
                case _FILE_PATH_SEPARATOR: {
                    return Str.get(File.pathSeparator);
                }
                case _FILE_PATH_TO_NATIVE: {
                    return this.pathToNative(ctx);
                }
                case _FILE_PATH_TO_URI: {
                    return this.pathToUri(ctx);
                }
                case _FILE_READ_BINARY: {
                    return this.readBinary(ctx);
                }
                case _FILE_READ_TEXT: {
                    return this.readText(ctx);
                }
                case _FILE_RESOLVE_PATH: {
                    return this.resolvePath(ctx);
                }
                case _FILE_SIZE: {
                    return this.size(ctx);
                }
                case _FILE_TEMP_DIR: {
                    return Str.get(Prop.TMP);
                }
                case _FILE_WRITE: {
                    return this.write(false, ctx);
                }
                case _FILE_WRITE_BINARY: {
                    return this.writeBinary(false, ctx);
                }
                case _FILE_WRITE_TEXT: {
                    return this.writeText(false, ctx);
                }
                case _FILE_WRITE_TEXT_LINES: {
                    return this.writeTextLines(false, ctx);
                }
            }
            return super.item(ctx, ii);
        }
        catch (IOException ex) {
            throw Err.FILE_IE.get(this.info, ex);
        }
    }

    private Item lastModified(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        if (!path.exists()) {
            throw Err.FILE_NF.get(this.info, path.getAbsolutePath());
        }
        return new Dtm(path.lastModified(), this.info);
    }

    private Item size(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        if (!path.exists()) {
            throw Err.FILE_NF.get(this.info, path.getAbsolutePath());
        }
        return Int.get(path.isDirectory() ? 0L : path.length());
    }

    private Str name(QueryContext ctx) throws QueryException {
        return Str.get(this.checkFile(0, ctx).getName());
    }

    private Str parent(QueryContext ctx) throws QueryException {
        String parent = this.checkFile(0, ctx).getAbsoluteFile().getParent();
        return parent == null ? null : Str.get(FNFile.dir(parent));
    }

    private Str pathToNative(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        try {
            String nat = path.getCanonicalFile().getPath();
            return Str.get(path.isDirectory() ? FNFile.dir(nat) : nat);
        }
        catch (IOException ex) {
            throw Err.FILE_IE_PATH.get(this.info, path);
        }
    }

    private Uri pathToUri(QueryContext ctx) throws QueryException {
        return Uri.uri(this.checkFile(0, ctx).toURI().toString());
    }

    private Str resolvePath(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        File abs = path.getAbsoluteFile();
        return Str.get(abs.isDirectory() ? FNFile.dir(abs.getPath()) : abs.getPath());
    }

    private Iter list(QueryContext ctx) throws QueryException {
        File dir = this.checkFile(0, ctx);
        try {
            dir = new File(dir.getCanonicalPath());
        }
        catch (IOException ex) {
            throw Err.FILE_IE_PATH.get(this.info, dir);
        }
        if (!dir.isDirectory()) {
            throw Err.FILE_ND.get(this.info, dir);
        }
        boolean rec = this.optionalBool(1, ctx);
        Pattern pat = this.expr.length == 3 ? Pattern.compile(IOFile.regex(Token.string(this.checkStr(this.expr[2], ctx))), Prop.CASE ? 0 : 2) : null;
        final StringList list = new StringList();
        String p = dir.getPath();
        int l = p.length() + (p.endsWith(File.separator) ? 0 : 1);
        this.list(l, dir, list, rec, pat);
        return new Iter(){
            int c;

            @Override
            public Item next() {
                return this.c < list.size() ? Str.get(list.get(this.c++)) : null;
            }
        };
    }

    private void list(int root, File dir, StringList list, boolean rec, Pattern pat) throws QueryException {
        File[] ch = dir.listFiles();
        if (ch == null) {
            return;
        }
        if (rec) {
            for (File f : ch) {
                if (!f.isDirectory() || this.mayBeLink(f)) continue;
                this.list(root, f, list, rec, pat);
            }
        }
        for (File f : ch) {
            if (pat != null && !pat.matcher(f.getName()).matches()) continue;
            String file = f.getPath().substring(root);
            list.add(f.isDirectory() ? FNFile.dir(file) : file);
        }
    }

    private boolean mayBeLink(File f) throws QueryException {
        try {
            String p1 = f.getAbsolutePath();
            String p2 = f.getCanonicalPath();
            return !(!Prop.CASE ? p1.equalsIgnoreCase(p2) : p1.equals(p2));
        }
        catch (IOException ex) {
            throw Err.FILE_IE_PATH.get(this.info, f);
        }
    }

    private synchronized Item createDir(QueryContext ctx) throws QueryException {
        File f;
        File path = this.checkFile(0, ctx);
        try {
            f = path.getCanonicalFile();
        }
        catch (IOException ex) {
            throw Err.FILE_IE_PATH.get(this.info, path);
        }
        while (!f.exists()) {
            if ((f = f.getParentFile()) != null) continue;
            throw Err.FILE_IE_PATH.get(this.info, path);
        }
        if (f.isFile()) {
            throw Err.FILE_E.get(this.info, path);
        }
        if (!path.exists() && !path.mkdirs()) {
            throw Err.FILE_IE_DIR.get(this.info, path);
        }
        return null;
    }

    private synchronized Item createTemp(boolean dir, QueryContext ctx) throws QueryException, IOException {
        File file;
        File root;
        String suf;
        String pref = Token.string(this.checkStr(this.expr[0], ctx));
        String string = suf = this.expr.length > 1 ? Token.string(this.checkStr(this.expr[1], ctx)) : "";
        if (this.expr.length > 2) {
            root = this.checkFile(2, ctx);
            if (root.isFile()) {
                throw Err.FILE_ND.get(this.info, root);
            }
        } else {
            root = new File(Prop.TMP);
        }
        Random rnd = new Random();
        while ((file = new File(root, pref + rnd.nextLong() + suf)).exists()) {
        }
        String path = file.getPath();
        if (dir) {
            if (!file.mkdirs()) {
                throw Err.FILE_IE_DIR.get(this.info, file);
            }
            path = FNFile.dir(path);
        } else {
            new IOFile(file).write(Token.EMPTY);
        }
        return Str.get(path);
    }

    private synchronized Item delete(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        if (!path.exists()) {
            throw Err.FILE_NF.get(this.info, path.getAbsolutePath());
        }
        if (this.optionalBool(1, ctx)) {
            this.deleteRec(path);
        } else if (!path.delete()) {
            throw (path.isDirectory() ? Err.FILE_ID_FULL : Err.FILE_IE_DEL).get(this.info, path);
        }
        return null;
    }

    private synchronized void deleteRec(File path) throws QueryException {
        File[] ch = path.listFiles();
        if (ch != null) {
            for (File f : ch) {
                this.deleteRec(f);
            }
        }
        if (!path.delete()) {
            throw Err.FILE_IE_DEL.get(this.info, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private B64 readBinary(QueryContext ctx) throws QueryException, IOException {
        long len;
        File path = this.checkFile(0, ctx);
        long off = this.expr.length > 1 ? this.checkItr(this.expr[1], ctx) : 0L;
        long l = len = this.expr.length > 2 ? this.checkItr(this.expr[2], ctx) : 0L;
        if (!path.exists()) {
            throw Err.FILE_NF.get(this.info, path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            throw Err.FILE_ID.get(this.info, path.getAbsolutePath());
        }
        if (this.expr.length == 1) {
            return new B64Stream(new IOFile(path), Err.FILE_IE);
        }
        DataAccess da = new DataAccess(new IOFile(path));
        try {
            long dlen = da.length();
            if (this.expr.length == 2) {
                len = dlen - off;
            }
            if (off < 0L || off > dlen || len < 0L || off + len > dlen) {
                throw Err.FILE_OOR.get(this.info, off, off + len);
            }
            da.cursor(off);
            B64 b64 = new B64(da.readBytes((int)len));
            return b64;
        }
        finally {
            da.close();
        }
    }

    private StrStream readText(QueryContext ctx) throws QueryException {
        File path = this.checkFile(0, ctx);
        String enc = this.encoding(1, Err.FILE_UE, ctx);
        if (!path.exists()) {
            throw Err.FILE_NF.get(this.info, path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            throw Err.FILE_ID.get(this.info, path.getAbsolutePath());
        }
        return new StrStream(new IOFile(path), enc, Err.FILE_IE, ctx);
    }

    private Iter readTextLines(QueryContext ctx) throws QueryException {
        return FNGen.textIter(this.readText(ctx).string(this.info));
    }

    private synchronized Item write(boolean append, QueryContext ctx) throws QueryException, IOException {
        File path = this.check(this.checkFile(0, ctx));
        Iter ir = this.expr[1].iter(ctx);
        SerializerOptions sopts = FuncOptions.serializer(this.expr.length > 2 ? this.expr[2].item(ctx, this.info) : null, this.info);
        PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
        try {
            Item it;
            Serializer ser = Serializer.get(out, sopts);
            while ((it = ir.next()) != null) {
                ser.serialize(it);
            }
            ser.close();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        finally {
            out.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Item writeText(boolean append, QueryContext ctx) throws QueryException, IOException {
        File path = this.check(this.checkFile(0, ctx));
        byte[] s = this.checkStr(this.expr[1], ctx);
        String enc = this.encoding(2, Err.FILE_UE, ctx);
        Charset cs = enc == null || enc == "UTF-8" ? null : Charset.forName(enc);
        PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
        try {
            out.write(cs == null ? s : Token.string(s).getBytes(cs));
        }
        finally {
            out.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Item writeTextLines(boolean append, QueryContext ctx) throws QueryException, IOException {
        File path = this.check(this.checkFile(0, ctx));
        Iter ir = this.expr[1].iter(ctx);
        String enc = this.encoding(2, Err.FILE_UE, ctx);
        Charset cs = enc == null || enc == "UTF-8" ? null : Charset.forName(enc);
        PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
        try {
            Item it;
            while ((it = ir.next()) != null) {
                if (!it.type.isStringOrUntyped()) {
                    throw Err.typeError(this, AtomType.STR, it);
                }
                byte[] s = it.string(this.info);
                out.write(cs == null ? s : Token.string(s).getBytes(cs));
                out.write(cs == null ? NL : Prop.NL.getBytes(cs));
            }
        }
        finally {
            out.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Item writeBinary(boolean append, QueryContext ctx) throws QueryException, IOException {
        block12: {
            long off;
            File path = this.check(this.checkFile(0, ctx));
            Bin bin = this.checkBinary(this.expr[1], ctx);
            long l = off = this.expr.length > 2 ? this.checkItr(this.expr[2], ctx) : 0L;
            if (this.expr.length == 2) {
                BufferOutput out = new BufferOutput(new FileOutputStream(path, append));
                try {
                    BufferInput is = bin.input(this.info);
                    try {
                        int i;
                        while ((i = ((InputStream)is).read()) != -1) {
                            out.write(i);
                        }
                        break block12;
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                finally {
                    out.close();
                }
            }
            RandomAccessFile raf = new RandomAccessFile(path, "rw");
            try {
                long dlen = raf.length();
                if (off < 0L || off > dlen) {
                    throw Err.FILE_OOR.get(this.info, off, dlen);
                }
                raf.seek(off);
                raf.write(bin.binary(this.info));
            }
            finally {
                raf.close();
            }
        }
        return null;
    }

    private File check(File path) throws QueryException {
        IOFile io = new IOFile(path);
        if (io.isDir()) {
            throw Err.FILE_ID.get(this.info, io);
        }
        IOFile dir = io.dir();
        if (!dir.exists()) {
            throw Err.FILE_ND.get(this.info, dir);
        }
        return path;
    }

    private synchronized Item relocate(boolean copy, QueryContext ctx) throws QueryException, IOException {
        String tpath;
        String spath;
        File src = this.checkFile(0, ctx).getCanonicalFile();
        File trg = this.checkFile(1, ctx).getCanonicalFile();
        if (!src.exists()) {
            throw Err.FILE_NF.get(this.info, src.getAbsolutePath());
        }
        if (trg.isDirectory()) {
            if ((trg = new File(trg, src.getName())).isDirectory()) {
                throw Err.FILE_ID.get(this.info, trg);
            }
        } else if (!trg.isFile()) {
            if (!trg.getParentFile().isDirectory()) {
                throw Err.FILE_ND.get(this.info, trg);
            }
        } else if (src.isDirectory()) {
            throw Err.FILE_ID.get(this.info, src);
        }
        if (!(spath = src.getPath()).equals(tpath = trg.getPath())) {
            if (copy) {
                this.copy(src, trg);
            } else {
                if (trg.exists() && (Prop.CASE || !spath.equalsIgnoreCase(tpath)) && !trg.delete()) {
                    throw Err.FILE_IE_DEL.get(this.info, src, trg);
                }
                if (!src.renameTo(trg)) {
                    throw Err.FILE_IE_MOVE.get(this.info, src, trg);
                }
            }
        }
        return null;
    }

    private synchronized void copy(File src, File trg) throws QueryException, IOException {
        if (src.isDirectory()) {
            if (!trg.mkdir()) {
                throw Err.FILE_IE_DIR.get(this.info, trg);
            }
            File[] files = src.listFiles();
            if (files == null) {
                throw Err.FILE_IE_ACCESS.get(this.info, src);
            }
            for (File f : files) {
                this.copy(f, new File(trg, f.getName()));
            }
        } else {
            new IOFile(src).copyTo(new IOFile(trg));
        }
    }

    private boolean optionalBool(int i, QueryContext ctx) throws QueryException {
        return i < this.expr.length && this.checkBln(this.expr[i], ctx);
    }

    private static String dir(String dir) {
        return dir.endsWith(File.separator) ? dir : dir + File.separator;
    }
}

