/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.io.InputStream;
import org.basex.build.xml.SAXWrapper;
import org.basex.build.xml.XMLParser;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.EncodingException;
import org.basex.io.in.InputException;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.up.primitives.Put;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.QueryInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class FNGen
extends StandardFunc {
    public FNGen(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case DATA: {
                return this.data(ctx);
            }
            case COLLECTION: {
                return this.collection(ctx).iter();
            }
            case URI_COLLECTION: {
                return this.uriCollection(ctx);
            }
            case UNPARSED_TEXT_LINES: {
                return this.unparsedTextLines(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case DOC: {
                return this.doc(ctx);
            }
            case DOC_AVAILABLE: {
                return this.docAvailable(ctx);
            }
            case UNPARSED_TEXT: {
                return this.unparsedText(ctx, false);
            }
            case UNPARSED_TEXT_AVAILABLE: {
                return this.unparsedText(ctx, true);
            }
            case PUT: {
                return this.put(ctx);
            }
            case PARSE_XML: {
                return this.parseXml(ctx, false);
            }
            case PARSE_XML_FRAGMENT: {
                return this.parseXml(ctx, true);
            }
            case SERIALIZE: {
                return this.serialize(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case COLLECTION: {
                return this.collection(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) {
        if (this.sig == Function.DATA && this.expr.length == 1) {
            SeqType t = this.expr[0].type();
            this.type = t.type.isNode() ? SeqType.get((Type)AtomType.ATM, t.occ) : t;
        }
        return this;
    }

    private Iter data(QueryContext ctx) throws QueryException {
        final Iter ir = ctx.iter(this.expr.length == 0 ? this.checkCtx(ctx) : this.expr[0]);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = ir.next();
                if (it == null) {
                    return null;
                }
                if (it instanceof FItem) {
                    throw Err.FIATOM.get(FNGen.this.info, it.type);
                }
                return StandardFunc.atom(it, FNGen.this.info);
            }
        };
    }

    private Value collection(QueryContext ctx) throws QueryException {
        Item it;
        Item item = it = this.expr.length == 0 ? null : this.expr[0].item(ctx, this.info);
        if (it == null) {
            return ctx.resource.collection(this.info);
        }
        byte[] in = this.checkEStr(it);
        if (!Uri.uri(in).isValid()) {
            throw Err.INVCOLL.get(this.info, new Object[]{in});
        }
        return ctx.resource.collection(new QueryInput(Token.string(in)), this.sc.baseIO(), this.info);
    }

    private Iter uriCollection(QueryContext ctx) throws QueryException {
        final ValueIter coll = this.collection(ctx).iter();
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = coll.next();
                return it == null ? null : Uri.uri(((ANode)it).baseURI(), false);
            }
        };
    }

    private Item put(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        byte[] file = this.checkEStr(this.expr[1], ctx);
        ANode nd = this.checkNode(this.expr[0], ctx);
        if (nd.type != NodeType.DOC && nd.type != NodeType.ELM) {
            throw Err.UPFOTYPE.get(this.info, this.expr[0]);
        }
        Uri u = Uri.uri(file);
        if (u == Uri.EMPTY || !u.isValid()) {
            throw Err.UPFOURI.get(this.info, new Object[]{file});
        }
        DBNode target = ctx.updates.determineDataRef(nd, ctx);
        String uri = IO.get(u.toJava()).path();
        if (!ctx.updates.putPaths.add(uri)) {
            throw Err.UPURIDUP.get(this.info, uri);
        }
        ctx.updates.add(new Put(target.pre, target.data, uri, this.info), ctx);
        return null;
    }

    private ANode doc(QueryContext ctx) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            return null;
        }
        byte[] in = this.checkEStr(it);
        if (!Uri.uri(in).isValid()) {
            throw Err.INVDOC.get(this.info, new Object[]{in});
        }
        return ctx.resource.doc(new QueryInput(Token.string(in)), this.sc.baseIO(), this.info);
    }

    private Bln docAvailable(QueryContext ctx) throws QueryException {
        try {
            return Bln.get(this.doc(ctx) != null);
        }
        catch (QueryException ex) {
            Err err = ex.err();
            if (err != null && (err.is(Err.ErrType.FODC) && (err.code.endsWith("0002") || err.code.endsWith("0004")) || err.is(Err.ErrType.BXDB) && err.code.endsWith("0006"))) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Item unparsedText(QueryContext ctx, boolean check) throws QueryException {
        this.checkCreate(ctx);
        byte[] path = this.checkStr(this.expr[0], ctx);
        IO base = this.sc.baseIO();
        if (base == null) {
            throw Err.STBASEURI.get(this.info, new Object[0]);
        }
        String enc = null;
        try {
            enc = this.encoding(1, Err.WHICHENC, ctx);
            String p = Token.string(path);
            if (p.indexOf(35) != -1) {
                throw Err.FRAGID.get(this.info, p);
            }
            if (!Uri.uri(p).isValid()) {
                throw Err.INVURL.get(this.info, p);
            }
            IO io = base.merge(p);
            String[] rp = ctx.resource.resources.get(io.path());
            if (rp != null && rp.length > 0) {
                io = IO.get(rp[0]);
                if (rp.length > 1) {
                    enc = rp[1];
                }
            }
            if (!io.exists()) {
                throw Err.RESNF.get(this.info, p);
            }
            InputStream is = io.inputStream();
            try {
                TextInput ti = new TextInput(io).encoding(enc).validate(true);
                if (!check) {
                    Str str = Str.get(ti.content());
                    return str;
                }
                while (ti.read() != -1) {
                }
                Bln bln = Bln.TRUE;
                return bln;
            }
            finally {
                is.close();
            }
        }
        catch (QueryException ex) {
            if (!check) throw ex;
            if (ex.err().is(Err.ErrType.XPTY)) throw ex;
            return Bln.FALSE;
        }
        catch (IOException ex) {
            if (check) {
                return Bln.FALSE;
            }
            if (!(ex instanceof InputException)) {
                throw Err.RESNF.get(this.info, new Object[]{path});
            }
            boolean inv = ex instanceof EncodingException || enc != null;
            throw (inv ? Err.INVCHARS : Err.WHICHCHARS).get(this.info, ex);
        }
    }

    Iter unparsedTextLines(QueryContext ctx) throws QueryException {
        return FNGen.textIter(this.unparsedText(ctx, false).string(this.info));
    }

    static Iter textIter(byte[] str) {
        try {
            final NewlineInput nli = new NewlineInput(new ArrayInput(str));
            final TokenBuilder tb = new TokenBuilder();
            return new Iter(){

                @Override
                public Item next() {
                    try {
                        return nli.readLine(tb) ? Str.get(tb.finish()) : null;
                    }
                    catch (IOException ex) {
                        throw Util.notExpected(ex);
                    }
                }
            };
        }
        catch (IOException ex) {
            throw Util.notExpected(ex);
        }
    }

    private ANode parseXml(QueryContext ctx, boolean frag) throws QueryException {
        Item item = this.expr[0].item(ctx, this.info);
        if (item == null) {
            return null;
        }
        try {
            IOContent io = new IOContent(this.checkStr(item), Token.string(this.sc.baseURI().string()));
            return FNGen.parseXml(io, ctx.context, frag);
        }
        catch (IOException ex) {
            throw Err.SAXERR.get(this.info, ex);
        }
    }

    private Str serialize(QueryContext ctx) throws QueryException {
        Item it = this.expr.length > 1 ? this.expr[1].item(ctx, this.info) : null;
        SerializerOptions sopts = FuncOptions.serializer(it, this.info);
        return Str.get(this.serialize(this.expr[0].iter(ctx), sopts, Err.SERANY));
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return (flag == Expr.Flag.X30 || flag == Expr.Flag.CTX) && this.sig == Function.DATA && this.expr.length == 0 || super.has(flag);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (FNGen.oneOf(this.sig, Function.DATA) && this.expr.length == 0) {
            if (!visitor.lock("%CTX")) {
                return false;
            }
        } else if (FNGen.oneOf(this.sig, Function.DOC_AVAILABLE, Function.DOC, Function.COLLECTION, Function.URI_COLLECTION)) {
            if (this.expr.length == 0) {
                if (FNGen.oneOf(this.sig, Function.COLLECTION, Function.URI_COLLECTION) && !visitor.lock("%COLL")) {
                    return false;
                }
            } else if (!(this.expr[0] instanceof Str)) {
                if (!visitor.lock(null)) {
                    return false;
                }
            } else {
                QueryInput qi = new QueryInput(Token.string(((Str)this.expr[0]).string()));
                if (qi.db == null && !visitor.lock(null)) {
                    return false;
                }
                if (!visitor.lock(qi.db)) {
                    return false;
                }
            }
        }
        return super.accept(visitor);
    }

    @Override
    public boolean iterable() {
        return this.sig == Function.COLLECTION || super.iterable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ANode parseXml(IO input, Context ctx, boolean frag) throws IOException {
        MainOptions opts = ctx.options;
        boolean chop = opts.get(MainOptions.CHOP);
        try {
            opts.set(MainOptions.CHOP, false);
            DBNode dBNode = new DBNode(frag || opts.get(MainOptions.INTPARSE) != false ? new XMLParser(input, ctx.options, frag) : new SAXWrapper(input, ctx.options));
            return dBNode;
        }
        finally {
            opts.set(MainOptions.CHOP, chop);
        }
    }
}

