/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class FNNode
extends StandardFunc {
    public FNNode(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = (this.expr.length == 0 ? this.checkCtx(ctx) : this.expr[0]).item(ctx, this.info);
        ANode node = it == null ? null : this.checkNode(it);
        switch (this.sig) {
            case NODE_NAME: {
                QNm qname = node != null ? node.qname() : null;
                return qname != null && qname.string().length != 0 ? qname : null;
            }
            case DOCUMENT_URI: {
                if (node == null || node.type != NodeType.DOC) {
                    return null;
                }
                byte[] uri = node.baseURI();
                return uri.length == 0 ? null : Uri.uri(uri, false);
            }
            case NILLED: {
                return node == null || node.type != NodeType.ELM ? null : Bln.FALSE;
            }
            case BASE_URI: {
                if (node == null) {
                    return null;
                }
                if (node.type != NodeType.ELM && node.type != NodeType.DOC && node.parent() == null) {
                    return null;
                }
                Uri base = Uri.EMPTY;
                ANode n = node;
                do {
                    if (n == null) {
                        return this.sc.baseURI().resolve(base, this.info);
                    }
                    Uri bu = Uri.uri(n.baseURI(), false);
                    if (!bu.isValid()) {
                        throw Err.FUNCAST.get(ii, bu.type, bu);
                    }
                    base = bu.resolve(base, this.info);
                    if (n.type == NodeType.DOC && n instanceof DBNode) break;
                    n = n.parent();
                } while (!base.isAbsolute());
                return base;
            }
            case NAME: {
                QNm qname = node != null ? node.qname() : null;
                return qname != null ? Str.get(qname.string()) : Str.ZERO;
            }
            case LOCAL_NAME: {
                QNm qname = node != null ? node.qname() : null;
                return qname != null ? Str.get(qname.local()) : Str.ZERO;
            }
            case NAMESPACE_URI: {
                QNm qname = node != null ? node.qname() : null;
                return qname != null ? Uri.uri(qname.uri(), false) : Uri.EMPTY;
            }
            case ROOT: {
                ANode p;
                ANode n = node;
                while (n != null && (p = n.parent()) != null) {
                    n = p;
                }
                return n;
            }
            case GENERATE_ID: {
                return node == null ? Str.ZERO : Str.get(new TokenBuilder(QueryText.ID).addInt(node.id).finish());
            }
            case HAS_CHILDREN: {
                return Bln.get(node != null && node.hasChildren());
            }
            case PATH: {
                return node != null ? FNNode.path(node) : null;
            }
        }
        return super.item(ctx, ii);
    }

    private static Str path(ANode node) {
        ANode n = node;
        TokenList tl = new TokenList();
        while (n.parent() != null) {
            ANode fs;
            AxisIter ai;
            QNm qnm;
            int i = 1;
            TokenBuilder tb = new TokenBuilder();
            if (n.type == NodeType.ATT) {
                tb.add(64);
                qnm = n.qname();
                byte[] uri = qnm.uri();
                if (uri.length != 0) {
                    tb.add("Q{").add(qnm.uri()).add(125);
                }
                tb.add(qnm.local());
            } else if (n.type == NodeType.ELM) {
                qnm = n.qname();
                ai = n.precedingSibling();
                while ((fs = ai.next()) != null) {
                    QNm q = fs.qname();
                    if (q == null || !q.eq(qnm)) continue;
                    ++i;
                }
                tb.add("Q{").add(qnm.uri()).add(125).add(qnm.local());
                tb.add(91).add(Integer.toString(i)).add(93);
            } else if (n.type == NodeType.COM || n.type == NodeType.TXT) {
                ANode fs2;
                AxisIter ai2 = n.precedingSibling();
                while ((fs2 = ai2.next()) != null) {
                    if (fs2.type != n.type) continue;
                    ++i;
                }
                tb.addExt(n.type() + "[%]", i);
            } else if (n.type == NodeType.PI) {
                qnm = n.qname();
                ai = n.precedingSibling();
                while ((fs = ai.next()) != null) {
                    if (fs.type != n.type || !fs.qname().eq(qnm)) continue;
                    ++i;
                }
                tb.add(n.type.string()).add(40).add(qnm.local());
                tb.add(")[").add(Integer.toString(i)).add(93);
            }
            tl.add(tb.finish());
            n = n.parent();
        }
        TokenBuilder tb = new TokenBuilder();
        if (n.type != NodeType.DOC) {
            tb.add("Q{").add(QueryText.FNURI).add("}root()");
        }
        for (int i = tl.size() - 1; i >= 0; --i) {
            tb.add(47).add(tl.get(i));
        }
        return Str.get(tb.isEmpty() ? Token.SLASH : tb.finish());
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.X30 && this.expr.length == 0 && FNNode.oneOf(this.sig, Function.DOCUMENT_URI, Function.NODE_NAME, Function.NILLED) || flag == Expr.Flag.CTX && this.expr.length == 0 || super.has(flag);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return (this.expr.length != 0 || visitor.lock("%CTX")) && super.accept(visitor);
    }
}

