/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Collation;
import org.basex.query.util.Compare;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNSimple
extends StandardFunc {
    public FNSimple(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case ONE_OR_MORE: {
                final Iter ir = this.expr[0].iter(ctx);
                long len = ir.size();
                if (len == 0L) {
                    throw Err.EXPECTOM.get(this.info, new Object[0]);
                }
                if (len > 0L) {
                    return ir;
                }
                return new Iter(){
                    private boolean first = true;

                    @Override
                    public Item next() throws QueryException {
                        Item it = ir.next();
                        if (this.first) {
                            if (it == null) {
                                throw Err.EXPECTOM.get(FNSimple.this.info, new Object[0]);
                            }
                            this.first = false;
                        }
                        return it;
                    }
                };
            }
            case UNORDERED: {
                return ctx.iter(this.expr[0]);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case ONE_OR_MORE: {
                Value val = ctx.value(this.expr[0]);
                if (val.isEmpty()) {
                    throw Err.EXPECTOM.get(this.info, new Object[0]);
                }
                return val;
            }
            case UNORDERED: {
                return ctx.value(this.expr[0]);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr.length == 1 ? this.expr[0] : null;
        switch (this.sig) {
            case FALSE: {
                return Bln.FALSE;
            }
            case TRUE: {
                return Bln.TRUE;
            }
            case EMPTY: {
                return Bln.get(e.iter(ctx).next() == null);
            }
            case EXISTS: {
                return Bln.get(e.iter(ctx).next() != null);
            }
            case BOOLEAN: {
                return Bln.get(e.ebv(ctx, this.info).bool(this.info));
            }
            case NOT: {
                return Bln.get(!e.ebv(ctx, this.info).bool(this.info));
            }
            case DEEP_EQUAL: {
                return Bln.get(this.deep(ctx));
            }
            case DEEP_EQUAL_OPT: {
                return Bln.get(this.deepOpt(ctx));
            }
            case ZERO_OR_ONE: {
                Iter ir = e.iter(ctx);
                Item it = ir.next();
                if (it != null && ir.next() != null) {
                    throw Err.EXPECTZ0.get(this.info, new Object[0]);
                }
                return it;
            }
            case EXACTLY_ONE: {
                Iter ir = e.iter(ctx);
                Item it = ir.next();
                if (it == null || ir.next() != null) {
                    throw Err.EXPECTO.get(this.info, new Object[0]);
                }
                return it;
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) {
        if (this.expr.length == 0) {
            return this;
        }
        Expr e = this.expr[0];
        switch (this.sig) {
            case EMPTY: 
            case EXISTS: {
                return e.size() == -1L || e.has(Expr.Flag.NDT) || e.has(Expr.Flag.CNS) ? this : Bln.get(this.sig == Function.EMPTY ^ !e.isEmpty());
            }
            case BOOLEAN: {
                return e.type().eq(SeqType.BLN) ? e : this;
            }
            case NOT: {
                if (e.isFunction(Function.EMPTY)) {
                    ctx.compInfo("rewriting %", this);
                    this.expr = ((Arr)e).expr;
                    this.sig = Function.EXISTS;
                } else if (e.isFunction(Function.EXISTS)) {
                    ctx.compInfo("rewriting %", this);
                    this.expr = ((Arr)e).expr;
                    this.sig = Function.EMPTY;
                } else {
                    if (e instanceof CmpV || e instanceof CmpG) {
                        Cmp c = ((Cmp)e).invert();
                        return c == e ? this : c;
                    }
                    if (e.isFunction(Function.NOT)) {
                        return FNSimple.compBln(((Arr)e).expr[0], this.info);
                    }
                    this.expr[0] = e.compEbv(ctx);
                }
                return this;
            }
            case ZERO_OR_ONE: {
                this.type = SeqType.get(e.type().type, SeqType.Occ.ZERO_ONE);
                return e.type().zeroOrOne() ? e : this;
            }
            case EXACTLY_ONE: {
                this.type = SeqType.get(e.type().type, SeqType.Occ.ONE);
                return e.type().one() ? e : this;
            }
            case ONE_OR_MORE: {
                this.type = SeqType.get(e.type().type, SeqType.Occ.ONE_MORE);
                return e.type().mayBeZero() ? this : e;
            }
            case UNORDERED: {
                return e;
            }
        }
        return this;
    }

    @Override
    public Expr compEbv(QueryContext ctx) {
        if (this.expr.length == 0) {
            return this;
        }
        Expr e = this.expr[0];
        Expr ex = this;
        if (this.sig == Function.BOOLEAN) {
            if (!e.type().mayBeNumber()) {
                ex = e;
            }
        } else if (this.sig == Function.EXISTS && e.type().type.isNode()) {
            ex = e;
        }
        if (ex != this) {
            ctx.compInfo("rewriting %", this);
        }
        return ex;
    }

    private boolean deep(QueryContext ctx) throws QueryException {
        Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
        return new Compare(this.info).collation(coll).deep(ctx.iter(this.expr[0]), ctx.iter(this.expr[1]));
    }

    private boolean deepOpt(QueryContext ctx) throws QueryException {
        Compare cmp = new Compare(this.info);
        Compare.Mode[] modes = Compare.Mode.values();
        if (this.expr.length == 3) {
            Item it;
            Iter ir = this.expr[2].iter(ctx);
            while ((it = ir.next()) != null) {
                byte[] key = Token.uc(this.checkEStr(it));
                boolean found = false;
                for (Compare.Mode m : modes) {
                    found = Token.eq(key, Token.token(m.name()));
                    if (!found) continue;
                    cmp.flag(m);
                    break;
                }
                if (found) continue;
                throw Err.INVALIDOPTX.get(this.info, new Object[]{key});
            }
        }
        return cmp.deep(ctx.iter(this.expr[0]), ctx.iter(this.expr[1]));
    }
}

