/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaMapping;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Jav;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class JavaFunc
extends JavaMapping {
    private final Class<?> cls;
    private final String mth;

    JavaFunc(StaticContext sctx, InputInfo ii, Class<?> c, String m, Expr[] a) {
        super(sctx, ii, a);
        this.cls = c;
        this.mth = m;
    }

    @Override
    protected Object eval(Value[] args, QueryContext ctx) throws QueryException {
        try {
            return this.mth.equals("new") ? this.constructor(args) : this.method(args, ctx);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof QueryException ? ((QueryException)cause).info(this.info) : Err.JAVAERR.get(this.info, cause);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Util.debug(ex);
            throw Err.JAVAFUN.get(this.info, this.name(), JavaFunc.foundArgs(args));
        }
    }

    @Override
    public Expr copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        return new JavaFunc(this.sc, this.info, this.cls, this.mth, JavaFunc.copyAll((QueryContext)ctx, (VarScope)scp, vs, (Expr[])this.expr));
    }

    private Object constructor(Value[] ar) throws Exception {
        for (Constructor<?> con : this.cls.getConstructors()) {
            Object[] arg = JavaFunc.args(con.getParameterTypes(), null, ar, true);
            if (arg == null) continue;
            return con.newInstance(arg);
        }
        throw Err.JAVACON.get(this.info, this.name(), JavaFunc.foundArgs(ar));
    }

    private Object method(Value[] ar, QueryContext ctx) throws Exception {
        try {
            Field f = this.cls.getField(this.mth);
            boolean st = Modifier.isStatic(f.getModifiers());
            if (ar.length == (st ? 0 : 1)) {
                return f.get(st ? null : this.instObj(ar[0]));
            }
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
        for (Method meth : this.cls.getMethods()) {
            if (!meth.getName().equals(this.mth)) continue;
            boolean st = Modifier.isStatic(meth.getModifiers());
            Object[] arg = JavaFunc.args(meth.getParameterTypes(), null, ar, st);
            if (arg == null) continue;
            Object inst = null;
            if (!st && (inst = this.instObj(ar[0])) instanceof QueryModule) {
                QueryModule mod = (QueryModule)inst;
                mod.staticContext = this.sc;
                mod.queryContext = ctx;
            }
            return meth.invoke(inst, arg);
        }
        throw Err.JAVAMTH.get(this.info, this.name(), JavaFunc.foundArgs(ar));
    }

    private Object instObj(Value v) throws QueryException {
        return this.cls.isInstance(v) ? v : v.toJava();
    }

    static Object[] args(Class<?>[] params, boolean[] vTypes, Value[] args, boolean stat) throws QueryException {
        int s = stat ? 0 : 1;
        int l = args.length - s;
        if (l != params.length) {
            return null;
        }
        boolean[] vType = vTypes == null ? JavaFunc.values(params) : vTypes;
        Object[] vals = new Object[l];
        for (int a = 0; a < l; ++a) {
            Class<?> param = params[a];
            Value arg = args[s + a];
            if (arg.type.instanceOf(JavaFunc.type(param))) {
                vals[a] = arg.toJava();
                continue;
            }
            Object object = vals[a] = arg instanceof Jav || !vType[a] ? arg.toJava() : arg;
            if (param.isInstance(vals[a])) continue;
            return null;
        }
        return vals;
    }

    static boolean[] values(Class<?>[] params) {
        int l = params.length;
        boolean[] vals = new boolean[l];
        for (int a = 0; a < l; ++a) {
            vals[a] = Value.class.isAssignableFrom(params[a]);
        }
        return vals;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.cls.getName() + '.' + this.mth), this.expr);
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        if (this.mth.equals("new")) {
            sb.append("new").append(' ').append(Util.className(this.cls));
        } else {
            sb.append(this.name());
        }
        return sb.append("(...)").toString();
    }

    private String name() {
        return Util.className(this.cls) + '.' + this.mth;
    }

    @Override
    public String toString() {
        return this.cls + "." + this.mth + "(" + this.toString(", ") + ")";
    }
}

