/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.path.Test;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.Util;

public final class NameTest
extends Test {
    public final byte[] ln;
    private final byte[] defElemNS;

    public NameTest(boolean att) {
        this(null, Test.Mode.ALL, att, null);
    }

    public NameTest(QNm nm, Test.Mode t, boolean att, byte[] elemNS) {
        this.type = att ? NodeType.ATT : NodeType.ELM;
        this.ln = nm != null ? nm.local() : null;
        this.defElemNS = elemNS != null ? elemNS : Token.EMPTY;
        this.name = nm;
        this.mode = t;
    }

    @Override
    public boolean compile(QueryContext ctx) {
        Data data = ctx.data();
        if (data == null) {
            return true;
        }
        byte[] dataNS = data.nspaces.globalNS();
        if (dataNS == null) {
            return true;
        }
        boolean results = true;
        if (this.mode == Test.Mode.STD && !this.name.hasURI()) {
            if (this.type == NodeType.ATT || Token.eq(dataNS, this.defElemNS)) {
                this.mode = Test.Mode.LN;
            } else {
                results = false;
            }
        }
        if (results) {
            boolean bl = this.mode != Test.Mode.LN || (this.type == NodeType.ELM ? data.tagindex : data.atnindex).contains(this.ln) ? true : (results = false);
        }
        if (!results) {
            ctx.compInfo("removing unknown element/attribute %", this.name);
        }
        return results;
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean eq(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.mode) {
            case ALL: {
                return true;
            }
            case LN: {
                return Token.eq(this.ln, Token.local(node.name()));
            }
            case NS: {
                return Token.eq(this.name.uri(), node.qname(this.tmpq).uri());
            }
        }
        return this.type == NodeType.ATT && !this.name.hasURI() ? Token.eq(this.ln, node.name()) : this.name.eq(node.qname(this.tmpq));
    }

    public boolean eq(QNm nm) {
        switch (this.mode) {
            case ALL: {
                return true;
            }
            case LN: {
                return Token.eq(this.ln, nm.local());
            }
            case NS: {
                return Token.eq(this.name.uri(), nm.uri());
            }
        }
        return this.name.eq(nm);
    }

    public String toString() {
        if (this.mode == Test.Mode.ALL) {
            return "*";
        }
        if (this.mode == Test.Mode.LN) {
            return "*:" + Token.string(this.name.string());
        }
        String uri = this.name.uri().length == 0 || this.name.hasPrefix() ? "" : '{' + Token.string(this.name.uri()) + '}';
        return uri + (this.mode == Test.Mode.NS ? "*" : Token.string(this.name.string()));
    }

    @Override
    public Test intersect(Test other) {
        throw Util.notExpected(other);
    }
}

