/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.index.path.PathSummary;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CAttr;
import org.basex.query.expr.CDoc;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Preds;
import org.basex.query.expr.Root;
import org.basex.query.path.Axis;
import org.basex.query.path.Bang;
import org.basex.query.path.CachedPath;
import org.basex.query.path.MixedPath;
import org.basex.query.path.NameTest;
import org.basex.query.path.Step;
import org.basex.query.path.Test;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class Path
extends ParseExpr {
    public Expr root;
    public Expr[] steps;

    Path(InputInfo ii, Expr r, Expr[] s) {
        super(ii);
        this.root = r;
        this.steps = s;
    }

    public static Path get(InputInfo ii, Expr r, Expr ... path) {
        boolean axes = true;
        for (int p = 0; p < path.length; ++p) {
            Expr e = path[p];
            if (e instanceof Context) {
                e = Step.get(((ParseExpr)e).info, Axis.SELF, Test.NOD, new Expr[0]);
            } else if (e instanceof Filter) {
                Filter f = (Filter)e;
                if (f.root instanceof Context) {
                    e = Step.get(f.info, Axis.SELF, Test.NOD, f.preds);
                }
            }
            axes &= e instanceof Step;
            path[p] = e;
        }
        return axes ? new CachedPath(ii, r, path).finish(null) : new MixedPath(ii, r, path);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        int ss = this.steps.length;
        for (int s = 0; s < ss - 1; ++s) {
            this.checkNoUp(this.steps[s]);
        }
        this.steps[ss - 1].checkUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr compile(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.root != null) {
            this.setRoot(ctx, this.root.compile(ctx, scp));
        }
        Value v = ctx.value;
        try {
            ctx.value = this.root(ctx);
            Expr expr = this.compilePath(ctx, scp);
            return expr;
        }
        finally {
            ctx.value = v;
        }
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.root instanceof Context) {
            ctx.compInfo("removing context expression (.)", new Object[0]);
            this.root = null;
        }
        for (Expr e : this.steps) {
            if (!e.isEmpty()) continue;
            return this.optPre(null, ctx);
        }
        return this;
    }

    protected abstract Expr compilePath(QueryContext var1, VarScope var2) throws QueryException;

    final Value root(QueryContext ctx) {
        Value v;
        Value value = v = ctx != null ? ctx.value : null;
        if (this.root == null) {
            return v == null || v.type != NodeType.DOC ? v : null;
        }
        if (this.root.isValue()) {
            return (Value)this.root;
        }
        if (!(this.root instanceof Root) || v == null) {
            return null;
        }
        return v.size() == 1L ? Root.root(v) : v;
    }

    private void setRoot(QueryContext ctx, Expr rt) {
        this.root = rt;
        if (this.root instanceof Context) {
            ctx.compInfo("removing context expression (.)", new Object[0]);
            this.root = null;
        }
    }

    @Override
    public final boolean has(Expr.Flag flag) {
        if (flag == Expr.Flag.CTX) {
            return this.root == null || this.root.has(flag);
        }
        for (Expr s : this.steps) {
            if (!s.has(flag)) continue;
            return true;
        }
        return this.root != null && this.root.has(flag);
    }

    void optSteps(QueryContext ctx) {
        boolean opt = false;
        Expr[] st = this.steps;
        for (int l = 1; l < st.length; ++l) {
            if (!(st[l - 1] instanceof Step) || !(st[l] instanceof Step)) continue;
            Step prev = (Step)st[l - 1];
            Step curr = (Step)st[l];
            if (!prev.simple(Axis.DESCORSELF, false)) continue;
            if (curr.axis == Axis.CHILD && !curr.has(Expr.Flag.FCS)) {
                int sl = st.length;
                Expr[] tmp = new Expr[sl - 1];
                System.arraycopy(st, 0, tmp, 0, l - 1);
                System.arraycopy(st, l, tmp, l - 1, sl - l);
                st = tmp;
                curr.axis = Axis.DESC;
                opt = true;
                continue;
            }
            if (curr.axis != Axis.ATTR || curr.has(Expr.Flag.FCS)) continue;
            prev.test = new NameTest(false);
            opt = true;
        }
        if (opt) {
            ctx.compInfo("simplifying descendant-or-self step(s)", new Object[0]);
        }
        if (this.root == null && st.length == 1 && st[0] instanceof Step) {
            Step curr = (Step)st[0];
            if (curr.axis == Axis.ATTR && curr.test.mode == Test.Mode.STD) {
                curr.type = SeqType.NOD_ZO;
            }
        }
        this.steps = st;
    }

    long size(QueryContext ctx) {
        Value rt = this.root(ctx);
        if (rt == null || rt.type != NodeType.DOC) {
            return -1L;
        }
        Data data = rt.data();
        if (data == null || !data.meta.uptodate || (long)data.resources.docs().size() != rt.size()) {
            return -1L;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        long m = 1L;
        for (int s = 0; s < this.steps.length; ++s) {
            Step curr = this.axisStep(s);
            if (curr != null) {
                if ((nodes = curr.nodes(nodes, data)) != null) continue;
                return -1L;
            }
            if (s + 1 == this.steps.length) {
                m = this.steps[s].size();
                continue;
            }
            return -1L;
        }
        long sz = 0L;
        for (PathNode pn : nodes) {
            sz += (long)pn.stats.count;
        }
        return sz * m;
    }

    void voidStep(Expr[] stps, QueryContext ctx) {
        for (int l = 0; l < stps.length; ++l) {
            Step s = this.axisStep(l);
            if (s == null) continue;
            Axis sa = s.axis;
            if (l == 0) {
                if (this.root instanceof CAttr) {
                    if (sa != Axis.CHILD && sa != Axis.DESC) continue;
                    ctx.compInfo("Warning: '%' cannot have descendants.", this.root);
                    return;
                }
                if (!(this.root instanceof Root) && (!(this.root instanceof Value) || ((Value)this.root).type != NodeType.DOC) && !(this.root instanceof CDoc) || sa == Axis.CHILD || sa == Axis.DESC || sa == Axis.DESCORSELF || (sa == Axis.SELF || sa == Axis.ANCORSELF) && (s.test == Test.NOD || s.test == Test.DOC)) continue;
                ctx.compInfo("Warning: '%' cannot have % nodes.", new Object[]{this.root, sa});
                return;
            }
            Step ls = this.axisStep(l - 1);
            if (ls == null) continue;
            Axis lsa = ls.axis;
            boolean warning = true;
            if (sa == Axis.SELF || sa == Axis.DESCORSELF) {
                if (s.test == Test.NOD) continue;
                boolean bl = warning = lsa == Axis.ATTR && s.test.type != NodeType.ATT || ls.test == Test.TXT && s.test != Test.TXT;
                if (!warning) {
                    if (sa == Axis.DESCORSELF) continue;
                    QNm n0 = ls.test.name;
                    QNm n1 = s.test.name;
                    if (n0 == null || n1 == null || n0.local().length == 0 || n1.local().length == 0) continue;
                    warning = !n1.eq(n0);
                }
            } else if (sa == Axis.FOLLSIBL || sa == Axis.PRECSIBL) {
                warning = lsa == Axis.ATTR;
            } else if (sa == Axis.DESC || sa == Axis.CHILD || sa == Axis.ATTR) {
                warning = lsa == Axis.ATTR || ls.test == Test.TXT || ls.test == Test.COM || ls.test == Test.PI || sa == Axis.ATTR && s.test == Test.NSP;
            } else if (sa == Axis.PARENT || sa == Axis.ANC) {
                boolean bl = warning = ls.test == Test.DOC;
            }
            if (!warning) continue;
            ctx.compInfo("Warning: '%' will never yield results.", s);
            return;
        }
    }

    Expr children(QueryContext ctx, Data data) {
        int s;
        if (!data.meta.uptodate || data.nspaces.globalNS() == null) {
            return this;
        }
        Path path = this;
        for (s = 0; s < this.steps.length; ++s) {
            ArrayList<PathNode> pn;
            Step prev;
            Step step = prev = s > 0 ? this.axisStep(s - 1) : null;
            if (prev != null && prev.preds.length != 0) break;
            Step curr = this.axisStep(s);
            if (curr == null || curr.axis != Axis.DESC || curr.has(Expr.Flag.FCS) || (pn = this.pathNodes(data, s)) == null) continue;
            ArrayList<QNm> qnm = new ArrayList<QNm>();
            while (pn.get((int)0).par != null) {
                QNm nm = new QNm(data.tagindex.key(pn.get((int)0).name));
                if (nm.hasPrefix()) {
                    return this;
                }
                for (PathNode p : pn) {
                    if (pn.get((int)0).name == p.name) continue;
                    nm = null;
                }
                qnm.add(nm);
                pn = PathSummary.parent(pn);
            }
            ctx.compInfo("converting % to child steps", this.steps[s]);
            int ts = qnm.size();
            Expr[] stps = new Expr[ts + this.steps.length - s - 1];
            for (int t = 0; t < ts; ++t) {
                Expr[] preds = t == ts - 1 ? ((Preds)this.steps[s]).preds : new Expr[]{};
                QNm nm = (QNm)qnm.get(ts - t - 1);
                NameTest nt = nm == null ? new NameTest(false) : new NameTest(nm, Test.Mode.LN, false, null);
                stps[t] = Step.get(this.info, Axis.CHILD, nt, preds);
            }
            while (++s < this.steps.length) {
                stps[ts++] = this.steps[s];
            }
            path = Path.get(this.info, this.root, stps);
            break;
        }
        if (data.nspaces.size() == 0) {
            Step st;
            block5: for (s = 0; s < path.steps.length && (st = path.axisStep(s)) != null && st.axis == Axis.CHILD; ++s) {
                if (st.test.mode == Test.Mode.ALL || st.test.mode == null) continue;
                if (st.test.mode != Test.Mode.LN) break;
                int name = data.tagindex.id(st.test.name.local());
                for (PathNode pn : data.paths.desc(name, 1)) {
                    if (pn.level() != s + 1) continue;
                    continue block5;
                }
                ctx.compInfo("removing non-existing path %", path);
                return Empty.SEQ;
            }
        }
        return path;
    }

    Step axisStep(int i) {
        return this.steps[i] instanceof Step ? (Step)this.steps[i] : null;
    }

    ArrayList<PathNode> pathNodes(Data data, int l) {
        if (!data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> in = data.paths.root();
        for (int s = 0; s <= l; ++s) {
            boolean desc;
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            boolean bl = desc = curr.axis == Axis.DESC;
            if (!desc && curr.axis != Axis.CHILD || curr.test.mode != Test.Mode.LN) {
                return null;
            }
            int name = data.tagindex.id(curr.test.name.local());
            ArrayList<PathNode> al = new ArrayList<PathNode>();
            for (PathNode pn : PathSummary.desc(in, desc)) {
                if (pn.kind != 1 || name != pn.name) continue;
                if (!al.isEmpty() && ((PathNode)al.get(0)).level() != pn.level()) {
                    return null;
                }
                al.add(pn);
            }
            if (al.isEmpty()) {
                return null;
            }
            in = al;
        }
        return in;
    }

    public final Expr addPreds(QueryContext ctx, VarScope scp, Expr ... pred) throws QueryException {
        this.steps[this.steps.length - 1] = this.axisStep(this.steps.length - 1).addPreds(pred);
        return Path.get(this.info, this.root, this.steps).optimize(ctx, scp);
    }

    @Override
    public boolean removable(Var v) {
        return this.root == null || this.root.removable(v);
    }

    @Override
    public VarUsage count(Var v) {
        VarUsage inRoot = this.root == null ? VarUsage.NEVER : this.root.count(v);
        return VarUsage.sum(v, this.steps) == VarUsage.NEVER ? inRoot : VarUsage.MORE_THAN_ONCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Value oldVal = ctx.value;
        try {
            Expr rt;
            ctx.value = this.root(ctx);
            Expr expr = rt = this.root == null ? null : this.root.inline(ctx, scp, v, e);
            if (rt != null) {
                this.setRoot(ctx, rt);
                ctx.value = oldVal;
                ctx.value = this.root(ctx);
            }
            boolean change = rt != null;
            for (int i = 0; i < this.steps.length; ++i) {
                Expr nw = this.steps[i].inline(ctx, scp, v, e);
                if (nw == null) continue;
                this.steps[i] = nw;
                change = true;
            }
            Expr expr2 = change ? this.optimize(ctx, scp) : null;
            return expr2;
        }
        finally {
            ctx.value = oldVal;
        }
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.root, this.steps});
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.root != null) {
            sb.append(this.root);
        }
        for (Expr s : this.steps) {
            if (sb.length() != 0) {
                sb.append(s instanceof Bang ? " ! " : "/");
            }
            if (s instanceof Step) {
                sb.append(s);
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (this.root == null ? !visitor.lock("%CTX") : !this.root.accept(visitor)) {
            return false;
        }
        visitor.enterFocus();
        if (!Path.visitAll(visitor, this.steps)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final int exprSize() {
        int sz = 1;
        for (Expr e : this.steps) {
            sz += e.exprSize();
        }
        return this.root == null ? sz : sz + this.root.exprSize();
    }
}

