/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.StringOption;

final class DBOptions {
    private static final NumberOption[] N_OPT;
    private static final BooleanOption[] B_OPT;
    private static final StringOption[] S_OPT;
    private static final String[] K_N_OPT;
    private static final String[] K_B_OPT;
    private static final String[] K_S_OPT;
    protected final HashMap<Option<?>, Object> nprops = new HashMap();
    private final HashMap<Option<?>, Object> oprops = new HashMap();
    protected final HashMap<String, String> options;
    protected final QueryContext qc;
    private final InputInfo info;

    DBOptions(QueryContext qc, HashMap<String, String> options, InputInfo info) {
        this.options = options;
        this.qc = qc;
        this.info = info;
    }

    void check(boolean create) throws QueryException {
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String key = entry.getKey();
            if (!Token.eq(key, K_N_OPT) && !Token.eq(key, K_B_OPT) && !Token.eq(key, K_S_OPT) || !create && Token.eq(key, K_B_OPT[K_B_OPT.length - 1])) {
                throw Err.BASX_OPTIONS.get(this.info, key);
            }
            String v = entry.getValue();
            if (Token.eq(key, K_N_OPT)) {
                if (Token.toInt(v) >= 0) continue;
                throw Err.BASX_VALUE.get(this.info, key, v);
            }
            if (!Token.eq(key, K_B_OPT)) continue;
            if (Util.yes(v)) {
                this.options.put(key, "true");
                continue;
            }
            if (Util.no(v)) {
                this.options.put(key, "false");
                continue;
            }
            throw Err.BASX_VALUE.get(this.info, key, v);
        }
    }

    void initOptions() {
        int o;
        for (o = 0; o < K_N_OPT.length; ++o) {
            if (!this.options.containsKey(K_N_OPT[o])) continue;
            this.nprops.put(N_OPT[o], Token.toInt(this.options.get(K_N_OPT[o])));
        }
        for (o = 0; o < K_B_OPT.length; ++o) {
            if (!this.options.containsKey(K_B_OPT[o])) continue;
            this.nprops.put(B_OPT[o], Util.yes(this.options.get(K_B_OPT[o])));
        }
        for (o = 0; o < K_S_OPT.length; ++o) {
            if (!this.options.containsKey(K_S_OPT[o])) continue;
            this.nprops.put(S_OPT[o], this.options.get(K_S_OPT[o]));
        }
    }

    void assignOptions() {
        MainOptions opts = this.qc.context.options;
        for (Option<?> option : this.nprops.keySet()) {
            this.oprops.put(option, opts.get(option));
        }
        this.setOptions(this.nprops);
    }

    void resetOptions() {
        this.setOptions(this.oprops);
    }

    private void setOptions(HashMap<Option<?>, Object> map) {
        MainOptions opts = this.qc.context.options;
        for (Map.Entry<Option<?>, Object> e : map.entrySet()) {
            opts.put(e.getKey(), e.getValue());
        }
    }

    static {
        int o;
        N_OPT = new NumberOption[]{MainOptions.MAXCATS, MainOptions.MAXLEN, MainOptions.INDEXSPLITSIZE, MainOptions.FTINDEXSPLITSIZE};
        B_OPT = new BooleanOption[]{MainOptions.TEXTINDEX, MainOptions.ATTRINDEX, MainOptions.FTINDEX, MainOptions.STEMMING, MainOptions.CASESENS, MainOptions.DIACRITICS, MainOptions.UPDINDEX};
        S_OPT = new StringOption[]{MainOptions.LANGUAGE, MainOptions.STOPWORDS};
        K_N_OPT = new String[N_OPT.length];
        K_B_OPT = new String[B_OPT.length];
        K_S_OPT = new String[S_OPT.length];
        int n = N_OPT.length;
        int b = B_OPT.length;
        int s = S_OPT.length;
        for (o = 0; o < n; ++o) {
            DBOptions.K_N_OPT[o] = N_OPT[o].name().toLowerCase(Locale.ENGLISH);
        }
        for (o = 0; o < b; ++o) {
            DBOptions.K_B_OPT[o] = B_OPT[o].name().toLowerCase(Locale.ENGLISH);
        }
        for (o = 0; o < s; ++o) {
            DBOptions.K_S_OPT[o] = S_OPT[o].name().toLowerCase(Locale.ENGLISH);
        }
    }
}

