/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Put
extends DBUpdate {
    private final StringList paths = new StringList(1);
    public final int nodeid;

    public Put(int id, Data data, String path, InputInfo info) {
        super(UpdateType.FNPUT, data, info);
        this.nodeid = id;
        this.paths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() throws QueryException {
        for (String u : this.paths) {
            int pre = this.data.pre(this.nodeid);
            if (pre == -1) {
                return;
            }
            DBNode node = new DBNode(this.data, pre);
            try {
                PrintOutput po = new PrintOutput(u);
                try {
                    SerializerOptions pr = new SerializerOptions();
                    pr.set(SerializerOptions.INDENT, node.data.meta.chop ? SerializerOptions.YesNo.YES : SerializerOptions.YesNo.NO);
                    Serializer ser = Serializer.get(po, pr);
                    ser.serialize((Item)node);
                    ser.close();
                }
                finally {
                    po.close();
                }
            }
            catch (IOException ex) {
                throw Err.UPPUTERR.get(this.info, u);
            }
        }
    }

    @Override
    public void merge(Update up) {
        for (String path : ((Put)up).paths) {
            this.paths.add(path);
        }
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    public String toString() {
        return Util.className(this) + '[' + this.nodeid + ", " + this.paths.get(0) + ']';
    }

    @Override
    public void prepare(MemData tmp) {
    }
}

