/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.func.FNNum;
import org.basex.query.util.Err;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntSet;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.TokenList;

public final class DecFormatter
extends FormatUtil {
    private final byte[] digits;
    private final byte[] active;
    private final int zero;
    private byte[] inf = Token.token("Infinity");
    private byte[] nan = Token.token("NaN");
    private int pattern = 59;
    private int decimal = 46;
    private int grouping = 44;
    private int optional = 35;
    private int minus = 45;
    private int percent = 37;
    private int permille = 8240;

    public DecFormatter() throws QueryException {
        this(null, null);
    }

    public DecFormatter(InputInfo ii, TokenMap map) throws QueryException {
        int[] ss;
        int z = 48;
        if (map != null) {
            for (byte[] key : map) {
                String k = Token.string(key);
                byte[] v = map.get(key);
                if (k.equals("infinity")) {
                    this.inf = v;
                    continue;
                }
                if (k.equals("NaN")) {
                    this.nan = v;
                    continue;
                }
                if (v.length != 0 && Token.cl(v, 0) == v.length) {
                    int cp = Token.cp(v, 0);
                    if (k.equals("decimal-separator")) {
                        this.decimal = cp;
                        continue;
                    }
                    if (k.equals("grouping-separator")) {
                        this.grouping = cp;
                        continue;
                    }
                    if (k.equals("pattern-separator")) {
                        this.pattern = cp;
                        continue;
                    }
                    if (k.equals("minus-sign")) {
                        this.minus = cp;
                        continue;
                    }
                    if (k.equals("digit")) {
                        this.optional = cp;
                        continue;
                    }
                    if (k.equals("percent")) {
                        this.percent = cp;
                        continue;
                    }
                    if (k.equals("per-mille")) {
                        this.permille = cp;
                        continue;
                    }
                    if (!k.equals("zero-digit")) continue;
                    z = DecFormatter.zeroes(cp);
                    if (z == -1) {
                        throw Err.INVDECFORM.get(ii, k, v);
                    }
                    if (z == cp) continue;
                    throw Err.INVDECZERO.get(ii, Character.valueOf((char)cp));
                }
                throw Err.INVDECSINGLE.get(ii, k, v);
            }
        }
        this.zero = z;
        IntSet is = new IntSet();
        for (int s : ss = new int[]{this.decimal, this.grouping, this.percent, this.permille, this.zero, this.optional, this.pattern}) {
            if (is.add(s)) continue;
            throw Err.DUPLDECFORM.get(ii, Character.valueOf((char)s));
        }
        TokenBuilder tb = new TokenBuilder();
        for (int i = 0; i < 10; ++i) {
            tb.add(this.zero + i);
        }
        this.digits = tb.finish();
        this.active = tb.add(this.decimal).add(this.grouping).add(this.optional).finish();
    }

    public byte[] format(InputInfo ii, Item number, byte[] pict) throws QueryException {
        TokenList tl = new TokenList();
        byte[] pic = pict;
        int i = Token.indexOf(pic, this.pattern);
        if (i == -1) {
            tl.add(pic);
        } else {
            tl.add(Token.substring(pic, 0, i));
            pic = Token.substring(pic, i + Token.cl(pic, i));
            if (Token.contains(pic, this.pattern)) {
                throw Err.PICNUM.get(ii, new Object[]{pict});
            }
            tl.add(pic);
        }
        byte[][] patterns = tl.toArray();
        if (!this.check(patterns)) {
            throw Err.PICNUM.get(ii, new Object[]{pict});
        }
        Picture[] pics = this.analyze(patterns);
        return this.format(number, pics, ii);
    }

    private boolean check(byte[][] patterns) {
        for (byte[] pt : patterns) {
            int cl;
            boolean frac = false;
            boolean pas = false;
            boolean act = false;
            boolean dg = false;
            boolean opt1 = false;
            boolean opt2 = false;
            int pc = 0;
            int pm = 0;
            int ls = 0;
            for (int i = 0; i < pt.length; i += cl) {
                int ch = DecFormatter.ch(pt, i);
                cl = Token.cl(pt, i);
                boolean a = Token.contains(this.active, ch);
                if (ch == this.decimal) {
                    if (frac) {
                        return false;
                    }
                    frac = true;
                } else if (ch == this.grouping) {
                    if (i == 0 && frac || ls == this.decimal || i + cl < pt.length ? DecFormatter.ch(pt, i + cl) == this.decimal : !frac) {
                        return false;
                    }
                } else if (ch == this.percent) {
                    if (++pc > 1) {
                        return false;
                    }
                } else if (ch == this.permille) {
                    if (++pm > 1) {
                        return false;
                    }
                } else if (ch == this.optional) {
                    if (frac) {
                        opt2 = true;
                    } else {
                        if (dg) {
                            return false;
                        }
                        opt1 = true;
                    }
                } else if (Token.contains(this.digits, ch)) {
                    if (frac && opt2) {
                        return false;
                    }
                    dg = true;
                }
                if (a && pas && act) {
                    return false;
                }
                if (act) {
                    pas |= !a;
                }
                act |= a;
                ls = ch;
            }
            if (pc + pm > 1) {
                return false;
            }
            if (opt1 || opt2 || dg) continue;
            return false;
        }
        return true;
    }

    private Picture[] analyze(byte[][] patterns) {
        Picture[] pics = new Picture[patterns.length];
        for (int s = 0; s < patterns.length; ++s) {
            byte[] pt = patterns[s];
            Picture pic = new Picture();
            int p = 0;
            boolean act = false;
            int[] opt = new int[2];
            for (int i = 0; i < pt.length; i += Token.cl(pt, i)) {
                int ch = DecFormatter.ch(pt, i);
                boolean a = Token.contains(this.active, ch);
                if (ch == this.decimal) {
                    ++p;
                    act = false;
                } else if (ch == this.optional) {
                    int n = p;
                    opt[n] = opt[n] + 1;
                } else if (ch == this.grouping) {
                    if (p == 0) {
                        pic.group[p] = Array.add(pic.group[p], pic.min[p] + opt[p]);
                    }
                } else if (Token.contains(this.digits, ch)) {
                    int n = p;
                    pic.min[n] = pic.min[n] + 1;
                } else {
                    pic.pc = pic.pc | ch == this.percent;
                    pic.pm = pic.pm | ch == this.permille;
                    pic.fix[p == 0 && act ? p + 1 : p].add(ch);
                }
                act |= a;
            }
            int[] igp = pic.group[0];
            int igl = igp.length;
            for (int g = 0; g < igl; ++g) {
                igp[g] = pic.min[0] + opt[0] - igp[g];
            }
            if (igl > 1) {
                boolean reg = true;
                int i = igp[igl - 1];
                for (int g = igl - 2; g >= 0; --g) {
                    reg &= i * igl == igp[g];
                }
                if (reg) {
                    pic.group[0] = new int[]{i};
                }
            }
            pic.maxFrac = pic.min[1] + opt[1];
            pics[s] = pic;
        }
        return pics;
    }

    private byte[] format(Item it, Picture[] pics, InputInfo ii) throws QueryException {
        double d = it.dbl(ii);
        if (Double.isNaN(d)) {
            return this.nan;
        }
        boolean neg = d < 0.0 || d == 0.0 && Double.doubleToLongBits(d) == Long.MIN_VALUE;
        Picture pic = pics[neg && pics.length == 2 ? 1 : 0];
        TokenBuilder res = new TokenBuilder();
        TokenBuilder intgr = new TokenBuilder();
        TokenBuilder fract = new TokenBuilder();
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            intgr.add(this.inf);
        } else {
            int i;
            int fl;
            int il;
            int i2;
            Item num = it;
            if (pic.pc) {
                num = Calc.MULT.ev(ii, num, Int.get(100L));
            }
            if (pic.pm) {
                num = Calc.MULT.ev(ii, num, Int.get(1000L));
            }
            String s = ((num = FNNum.abs(FNNum.round(num, num.dbl(ii), pic.maxFrac, true, ii), ii)) instanceof Dbl || num instanceof Flt ? Dec.get(num.dbl(ii)) : num).toString();
            int sep = s.indexOf(46);
            int sl = s.length();
            for (i2 = il = sep == -1 ? sl : sep; i2 < pic.min[0]; ++i2) {
                intgr.add(this.zero);
            }
            for (i2 = 0; i2 < il; ++i2) {
                intgr.add(this.zero + s.charAt(i2) - 48);
            }
            if (pic.group[0].length == 1) {
                int pos = pic.group[0][0];
                for (int p = intgr.size() - (neg ? 2 : 1); p > 0; --p) {
                    if (p % pos != 0) continue;
                    intgr.insert(intgr.size() - p, this.grouping);
                }
            } else {
                for (i2 = 0; i2 < pic.group[0].length; ++i2) {
                    int pos = intgr.size() - pic.group[0][i2];
                    if (pos <= 0) continue;
                    intgr.insert(pos, this.grouping);
                }
            }
            int n = fl = sep == -1 ? 0 : sl - il - 1;
            if (fl != 0) {
                for (i = sep + 1; i < sl; ++i) {
                    fract.add(this.zero + s.charAt(i) - 48);
                }
            }
            for (i = fl; i < pic.min[1]; ++i) {
                fract.add(this.zero);
            }
            int ul = fract.size();
            for (int p = pic.group[1].length - 1; p >= 0; --p) {
                int pos = pic.group[1][p];
                if (pos >= ul) continue;
                fract.insert(pos, this.grouping);
            }
        }
        if (neg && pics.length != 2) {
            res.add(this.minus);
        }
        res.add(pic.fix[0].finish()).add(intgr.finish());
        if (!fract.isEmpty()) {
            res.add(this.decimal).add(fract.finish());
        }
        return res.add(pic.fix[1].finish()).finish();
    }

    static final class Picture {
        final TokenBuilder[] fix = new TokenBuilder[]{new TokenBuilder(), new TokenBuilder()};
        final int[][] group = new int[][]{new int[0], new int[0]};
        final int[] min = new int[]{0, 0};
        int maxFrac;
        boolean pc;
        boolean pm;

        Picture() {
        }
    }
}

