/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.format.DateFormat;
import org.basex.query.util.format.DateParser;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.util.format.FormatterDE;
import org.basex.query.util.format.FormatterEN;
import org.basex.query.util.format.IntFormat;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;

public abstract class Formatter
extends FormatUtil {
    private static final Pattern CALENDAR = Pattern.compile("(Q\\{([^}]*)\\})?([^}]+)");
    private static final byte[] MIL = Token.token("YXWVUTSRQPONZABCDEFGHIKLM");
    private static final byte[] NN = new byte[]{78, 110};
    private static final byte[][] CALENDARS = Token.tokens("ISO", "AD", "AH", "AME", "AM", "AP", "AS", "BE", "CB", "CE", "CL", "CS", "EE", "FE", "JE", "KE", "KY", "ME", "MS", "NS", "OS", "RS", "SE", "SH", "SS", "TE", "VE", "VS");
    private static final byte[] EN = Token.token("en");
    private static final TokenObjMap<Formatter> MAP = new TokenObjMap();

    public static Formatter get(byte[] ln) {
        String clz;
        Formatter form = MAP.get(ln);
        if (form == null && (form = (Formatter)Reflect.get(Reflect.find(clz = Util.className(Formatter.class) + Token.string(Token.uc(ln))))) == null) {
            form = MAP.get(EN);
        }
        return form;
    }

    protected abstract byte[] word(long var1, byte[] var3);

    protected abstract byte[] ordinal(long var1, byte[] var3);

    protected abstract byte[] month(int var1, int var2, int var3);

    protected abstract byte[] day(int var1, int var2, int var3);

    protected abstract byte[] ampm(boolean var1);

    protected abstract byte[] calendar();

    protected abstract byte[] era(long var1);

    public final byte[] formatDate(ADate date, byte[] lng, byte[] pic, byte[] cal, byte[] plc, InputInfo ii) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (lng.length != 0 && MAP.get(lng) == null) {
            tb.add("[Language: en]");
        }
        boolean iso = false;
        if (cal.length != 0) {
            Matcher m = CALENDAR.matcher(Token.string(cal));
            if (!m.matches()) {
                throw Err.CALQNAME.get(ii, new Object[]{cal});
            }
            QNm qnm = new QNm(m.group(3), m.group(1) == null || m.group(2).isEmpty() ? null : m.group(2));
            if (!qnm.hasURI()) {
                int c = -1;
                byte[] ln = qnm.local();
                int cl = CALENDARS.length;
                while (++c < cl && !Token.eq(CALENDARS[c], ln)) {
                }
                if (c == cl) {
                    throw Err.CALWHICH.get(ii, new Object[]{cal});
                }
                if (c > 1) {
                    tb.add("[Calendar: AD]");
                }
                boolean bl = iso = c == 0;
            }
        }
        if (plc.length != 0) {
            tb.add("[Place: ]");
        }
        DateParser dp = new DateParser(ii, pic);
        while (dp.more()) {
            int ch = dp.literal();
            if (ch == -1) {
                byte[] marker = dp.marker();
                if (marker.length == 0) {
                    throw Err.PICDATE.get(ii, new Object[]{pic});
                }
                int compSpec = Formatter.ch(marker, 0);
                byte[] pres = Token.ONE;
                boolean max = false;
                BigDecimal frac = null;
                long num = 0L;
                boolean dat = date.type == AtomType.DAT;
                boolean tim = date.type == AtomType.TIM;
                boolean err = false;
                switch (compSpec) {
                    case 89: {
                        num = Math.abs(date.yea());
                        max = true;
                        err = tim;
                        break;
                    }
                    case 77: {
                        num = date.mon();
                        err = tim;
                        break;
                    }
                    case 68: {
                        num = date.day();
                        err = tim;
                        break;
                    }
                    case 100: {
                        long y = date.yea();
                        int m = (int)date.mon() - 1;
                        while (--m >= 0) {
                            num += (long)ADate.dpm(y, m);
                        }
                        num += date.day();
                        err = tim;
                        break;
                    }
                    case 70: {
                        num = date.toJava().toGregorianCalendar().get(7) - 1;
                        if (num == 0L) {
                            num = 7L;
                        }
                        pres = NN;
                        err = tim;
                        break;
                    }
                    case 87: {
                        num = date.toJava().toGregorianCalendar().get(3);
                        err = tim;
                        break;
                    }
                    case 119: {
                        num = date.toJava().toGregorianCalendar().get(4);
                        if (iso && num == 0L) {
                            num = 5L;
                        }
                        err = tim;
                        break;
                    }
                    case 72: {
                        num = date.hou();
                        err = dat;
                        break;
                    }
                    case 104: {
                        num = date.hou() % 12L;
                        if (num == 0L) {
                            num = 12L;
                        }
                        err = dat;
                        break;
                    }
                    case 80: {
                        num = date.hou() / 12L;
                        pres = NN;
                        err = dat;
                        break;
                    }
                    case 109: {
                        num = date.min();
                        pres = Token.token("01");
                        err = dat;
                        break;
                    }
                    case 115: {
                        num = date.sec().intValue();
                        pres = Token.token("01");
                        err = dat;
                        break;
                    }
                    case 102: {
                        frac = date.sec().remainder(BigDecimal.ONE);
                        num = frac.movePointRight(3).intValue();
                        err = dat;
                        break;
                    }
                    case 90: 
                    case 122: {
                        num = date.zon();
                        pres = Token.token("01:01");
                        break;
                    }
                    case 67: {
                        pres = NN;
                        break;
                    }
                    case 69: {
                        num = date.yea();
                        pres = NN;
                        err = tim;
                        break;
                    }
                    default: {
                        throw Err.INVCOMPSPEC.get(ii, new Object[]{marker});
                    }
                }
                if (err) {
                    throw Err.PICINVCOMP.get(ii, marker, date.type);
                }
                if (pres == null) continue;
                DateFormat fp = new DateFormat(Token.substring(marker, 1), pres, ii);
                if (max) {
                    int mx = 0;
                    for (int s = 0; s < fp.primary.length; s += Token.cl(fp.primary, s)) {
                        ++mx;
                    }
                    if (mx > 1) {
                        fp.max = mx;
                    }
                }
                if (compSpec == 122 || compSpec == 90) {
                    tb.add(this.formatZone((int)num, fp, marker));
                    continue;
                }
                if (fp.first == 110) {
                    byte[] in = null;
                    if (compSpec == 77) {
                        in = this.month((int)num - 1, fp.min, fp.max);
                    } else if (compSpec == 70) {
                        in = this.day((int)num - 1, fp.min, fp.max);
                    } else if (compSpec == 80) {
                        in = this.ampm(num == 0L);
                    } else if (compSpec == 67) {
                        in = this.calendar();
                    } else if (compSpec == 69) {
                        in = this.era((int)num);
                    }
                    if (in != null) {
                        if (fp.cs == FormatUtil.Case.LOWER) {
                            in = Token.lc(in);
                        }
                        if (fp.cs == FormatUtil.Case.UPPER) {
                            in = Token.uc(in);
                        }
                        tb.add(in);
                        continue;
                    }
                    fp.first = 48;
                    fp.primary = Token.ONE;
                    tb.add(this.formatInt(num, fp));
                    continue;
                }
                if (frac != null && !frac.equals(BigDecimal.ZERO)) {
                    String s = frac.toString().replace("0.", "");
                    int sl = s.length();
                    if (fp.min > sl) {
                        s = Formatter.frac(frac, fp.min);
                    } else if (fp.max < sl) {
                        s = Formatter.frac(frac, fp.max);
                    } else {
                        int fl = fp.primary.length;
                        if (fl != 1 && fl != sl) {
                            s = Formatter.frac(frac, fl);
                        }
                    }
                    num = Token.toLong(s);
                }
                tb.add(this.formatInt(num, fp));
                continue;
            }
            tb.add(ch);
        }
        return tb.finish();
    }

    private static String frac(BigDecimal num, int len) {
        String s = num.setScale(len, 4).toString();
        int d = s.indexOf(46);
        return d == -1 ? s : s.substring(d + 1);
    }

    public final byte[] formatInt(long num, FormatParser fp) {
        boolean sign;
        long n = num;
        boolean bl = sign = n < 0L;
        if (sign) {
            n = -n;
        }
        TokenBuilder tb = new TokenBuilder();
        int ch = fp.first;
        if (ch == 119) {
            tb.add(this.word(n, fp.ordinal));
        } else if (ch == KANJI[1]) {
            Formatter.japanese(tb, n);
        } else if (ch == 105) {
            Formatter.roman(tb, n, fp.min);
        } else if (ch == 9312 || ch == 9332 || ch == 9352) {
            if (num < 1L || num > 20L) {
                tb.addLong(num);
            } else {
                tb.add((int)((long)ch + num - 1L));
            }
        } else {
            String seq = Formatter.sequence(ch);
            if (seq != null) {
                Formatter.alpha(tb, num, seq);
            } else {
                tb.add(this.number(n, fp, Formatter.zeroes(ch)));
            }
        }
        byte[] in = tb.finish();
        if (fp.cs == FormatUtil.Case.LOWER) {
            in = Token.lc(in);
        }
        if (fp.cs == FormatUtil.Case.UPPER) {
            in = Token.uc(in);
        }
        return sign ? Token.concat(new byte[]{45}, in) : in;
    }

    final byte[] formatZone(int num, FormatParser fp, byte[] marker) throws QueryException {
        boolean mil;
        boolean uc = Formatter.ch(marker, 0) == 90;
        boolean bl = mil = uc && Formatter.ch(marker, 1) == 90;
        if (num == Short.MAX_VALUE) {
            byte[] byArray;
            if (mil) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 74;
            } else {
                byArray = Token.EMPTY;
            }
            return byArray;
        }
        TokenBuilder tb = new TokenBuilder();
        if (!mil || !Formatter.addMilZone(num, tb)) {
            boolean minus;
            if (!uc) {
                tb.add("GMT");
            }
            boolean bl2 = minus = num < 0;
            if (fp.trad && num == 0) {
                tb.add(90);
            } else {
                tb.add(minus ? 45 : 43);
                TokenParser tp = new TokenParser(fp.primary);
                int c1 = tp.next();
                int c2 = tp.next();
                int c3 = tp.next();
                int c4 = tp.next();
                int z1 = Formatter.zeroes(c1);
                int z2 = Formatter.zeroes(c2);
                int z3 = Formatter.zeroes(c3);
                int z4 = Formatter.zeroes(c4);
                if (z1 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder("00"))).add(58);
                    tb.add(this.addZone(num, 1, new TokenBuilder("00")));
                } else if (z2 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1)));
                    if (c2 == -1) {
                        if (num % 60 != 0) {
                            tb.add(58).add(this.addZone(num, 1, new TokenBuilder("00")));
                        }
                    } else {
                        TokenBuilder t = new TokenBuilder().add(z3 == -1 ? 48 : z3);
                        if (z3 != -1 && z4 != -1) {
                            t.add(z4);
                        }
                        tb.add(c2).add(this.addZone(num, 1, t));
                    }
                } else if (z3 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1).add(c2)));
                    if (c3 == -1) {
                        if (num % 60 != 0) {
                            tb.add(58).add(this.addZone(num, 1, new TokenBuilder("00")));
                        }
                    } else {
                        int c5 = tp.next();
                        int z5 = Formatter.zeroes(c5);
                        TokenBuilder t = new TokenBuilder().add(z4 == -1 ? 48 : z4);
                        if (z4 != -1 && z5 != -1) {
                            t.add(z5);
                        }
                        tb.add(c3).add(this.addZone(num % 60, 1, t));
                    }
                } else if (z4 == -1) {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1)));
                    tb.add(this.addZone(num, 1, new TokenBuilder().add(c2).add(c3)));
                } else {
                    tb.add(this.addZone(num, 0, new TokenBuilder().add(c1).add(c2)));
                    tb.add(this.addZone(num, 1, new TokenBuilder().add(c3).add(c4)));
                }
            }
        }
        return tb.finish();
    }

    private byte[] addZone(int num, int c, TokenBuilder format) throws QueryException {
        int n;
        int n2 = n = c == 0 ? num / 60 : num % 60;
        if (num < 0) {
            n = -n;
        }
        return this.number(n, new IntFormat(format.finish(), null), Formatter.zeroes(format.cp(0)));
    }

    private static boolean addMilZone(int num, TokenBuilder tb) {
        int n = num / 60;
        if (num % 60 != 0 || n < -12 || n > 12) {
            return false;
        }
        tb.add(MIL[n + 12]);
        return true;
    }

    private static void alpha(TokenBuilder tb, long n, String a) {
        int al = a.length();
        if (n > (long)al) {
            Formatter.alpha(tb, (n - 1L) / (long)al, a);
        }
        if (n > 0L) {
            tb.add(a.charAt((int)((n - 1L) % (long)al)));
        } else {
            tb.add(Token.ZERO);
        }
    }

    private static void roman(TokenBuilder tb, long n, int min) {
        int s = tb.size();
        if (n > 0L && n < 4000L) {
            int v = (int)n;
            tb.add(ROMANM[v / 1000]);
            tb.add(ROMANC[v / 100 % 10]);
            tb.add(ROMANX[v / 10 % 10]);
            tb.add(ROMANI[v % 10]);
        } else {
            tb.addLong(n);
        }
        while (tb.size() - s < min) {
            tb.add(32);
        }
    }

    private static void japanese(TokenBuilder tb, long n) {
        if (n == 0L) {
            tb.add(KANJI[0]);
        } else {
            Formatter.jp(tb, n, false);
        }
    }

    private static void jp(TokenBuilder tb, long n, boolean i) {
        if (n != 0L) {
            if (n <= 9L) {
                if (n != 1L || !i) {
                    tb.add(KANJI[(int)n]);
                }
            } else if (n == 10L) {
                tb.add(KANJI[10]);
            } else if (n <= 99L) {
                Formatter.jp(tb, n, 10L, 10);
            } else if (n <= 999L) {
                Formatter.jp(tb, n, 100L, 11);
            } else if (n <= 9999L) {
                Formatter.jp(tb, n, 1000L, 12);
            } else if (n <= 99999999L) {
                Formatter.jp(tb, n, 10000L, 13);
            } else if (n <= 999999999999L) {
                Formatter.jp(tb, n, 100000000L, 14);
            } else if (n <= 9999999999999999L) {
                Formatter.jp(tb, n, 1000000000000L, 15);
            } else {
                tb.addLong(n);
            }
        }
    }

    private static void jp(TokenBuilder tb, long n, long f, int o) {
        Formatter.jp(tb, n / f, true);
        tb.add(KANJI[o]);
        Formatter.jp(tb, n % f, false);
    }

    private byte[] number(long num, FormatParser fp, int z) {
        int c;
        int rc;
        IntList pr = new TokenParser(fp.primary).toList();
        int rp = -1;
        boolean reg = false;
        for (int p = pr.size() - 1; p >= 0; --p) {
            int ch = pr.get(p);
            if (ch == 35 || ch >= z && ch <= z + 9) continue;
            if (rp == -1) {
                rp = pr.size() - p;
            }
            reg = (pr.size() - p) % rp == 0;
        }
        int n = rc = reg ? pr.get(pr.size() - rp) : 0;
        if (!reg) {
            rp = Integer.MAX_VALUE;
        }
        IntList cache = new IntList();
        byte[] n2 = Token.token(num);
        int b = n2.length - 1;
        int p = pr.size() - 1;
        int mn = fp.min;
        int mx = fp.max;
        while ((--mn >= 0 || b >= 0 || p >= 0) && --mx >= 0) {
            boolean sep;
            boolean bl = sep = cache.size() % rp == rp - 1;
            if (p >= 0) {
                c = pr.get(p--);
                if (b >= 0) {
                    if (c == 35 && sep) {
                        cache.add(rc);
                    }
                    cache.add(c == 35 || c >= z && c <= z + 9 ? n2[b--] - 48 + z : c);
                    continue;
                }
                if (c == 35) break;
                cache.add(c >= z && c <= z + 9 ? z : c);
                continue;
            }
            if (b >= 0) {
                if (sep) {
                    cache.add(rc);
                }
                cache.add(n2[b--] - 48 + z);
                continue;
            }
            cache.add(z);
        }
        TokenBuilder tb = new TokenBuilder();
        for (c = cache.size() - 1; c >= 0; --c) {
            tb.add(cache.get(c));
        }
        return tb.add(this.ordinal(num, fp.ordinal)).finish();
    }

    static {
        MAP.put(EN, new FormatterEN());
        MAP.put(Token.token("de"), new FormatterDE());
    }
}

