/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import org.basex.build.CsvParser;
import org.basex.build.HtmlParser;
import org.basex.build.JsonOptions;
import org.basex.build.JsonParser;
import org.basex.build.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.MimeTypes;
import org.basex.io.in.TextInput;
import org.basex.query.QueryException;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Err;
import org.basex.query.util.http.HTTPText;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public final class HTTPPayload {
    private final ValueBuilder payloads;
    private final InputStream in;
    private final InputInfo info;
    private final MainOptions options;

    public HTTPPayload(InputStream is, boolean body, InputInfo ii, MainOptions opts) {
        this.in = is;
        this.info = ii;
        this.options = opts;
        this.payloads = body ? new ValueBuilder() : null;
    }

    public FElem parse(boolean error, String ctype, String utype) throws IOException, QueryException {
        FElem body;
        String ct;
        String string = error ? "text/plain" : (ct = utype != null ? utype : HTTPPayload.contentType(ctype));
        if (MimeTypes.isMultipart(ct)) {
            byte[] boundary = this.boundary(ctype);
            if (boundary == null) {
                throw Err.HC_REQ.get(this.info, "No separation boundary specified");
            }
            body = new FElem(HTTPText.Q_MULTIPART).add(HTTPText.MEDIA_TYPE, ct).add(HTTPText.BOUNDARY, boundary);
            ANodeList parts = new ANodeList();
            this.extractParts(Token.concat(HTTPText.DASHES, boundary), parts);
            for (ANode node : parts) {
                body.add(node);
            }
        } else {
            body = new FElem(HTTPText.Q_BODY).add(HTTPText.MEDIA_TYPE, ct);
            if (this.payloads != null) {
                byte[] pl = this.extract(ct, HTTPPayload.charset(ctype));
                this.payloads.add(this.parse(pl, ct));
            }
        }
        return body;
    }

    public Value payloads() {
        return this.payloads.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extract(String ctype, String ce) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(this.in);
        try {
            int i;
            ByteList bl = new ByteList();
            while ((i = bis.read()) != -1) {
                bl.add(i);
            }
            if (MimeTypes.isXML(ctype) || MimeTypes.isText(ctype)) {
                byte[] byArray = new TextInput(new IOContent(bl.toArray())).encoding(ce).content();
                return byArray;
            }
            byte[] byArray = bl.toArray();
            return byArray;
        }
        finally {
            bis.close();
        }
    }

    private Value parse(byte[] payload, String ctype) throws QueryException {
        if (payload.length == 0) {
            return Empty.SEQ;
        }
        try {
            return HTTPPayload.value(new IOContent(payload), this.options, ctype, null);
        }
        catch (IOException ex) {
            throw Err.HC_PARSE.get(this.info, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractParts(byte[] sep, ANodeList parts) throws IOException, QueryException {
        try {
            byte[] l;
            do {
                if ((l = this.readLine()) != null) continue;
                throw Err.HC_REQ.get(this.info, "No body specified for http:part");
            } while (!Token.eq(sep, l));
            while (this.extractPart(sep, Token.concat(sep, HTTPText.DASHES), parts)) {
            }
        }
        finally {
            this.in.close();
        }
    }

    private boolean extractPart(byte[] sep, byte[] end, ANodeList parts) throws IOException, QueryException {
        byte[] line = this.readLine();
        if (line == null || Token.eq(line, end)) {
            return false;
        }
        String ctype = "text/plain";
        String enc = null;
        String ct = ctype;
        byte[] l = line;
        while (l != null && l.length > 0) {
            int pos = Token.indexOf(l, 58);
            if (pos > 0) {
                byte[] key = Token.substring(l, 0, pos);
                byte[] val = Token.trim(Token.substring(l, pos + 1));
                if (Token.eq(Token.lc(key), HTTPText.CONTENT_TYPE_LC)) {
                    ctype = Token.string(val);
                    enc = HTTPPayload.charset(ctype);
                    ct = HTTPPayload.contentType(ctype);
                }
                if (val.length != 0 && parts != null) {
                    parts.add(new FElem(HTTPText.Q_HEADER).add(HTTPText.NAME, key).add(HTTPText.VALUE, val));
                }
            }
            l = this.readLine();
        }
        if (parts != null) {
            parts.add(new FElem(HTTPText.Q_BODY).add(HTTPText.MEDIA_TYPE, ctype));
        }
        byte[] pl = this.extractPart(sep, end, enc);
        if (this.payloads != null) {
            this.payloads.add(this.parse(pl, ct));
        }
        return true;
    }

    private byte[] readLine() throws IOException {
        int b;
        ByteList bl = new ByteList();
        while ((b = this.in.read()) != -1) {
            while (b == 13) {
                b = this.in.read();
                if (b == 10) {
                    return bl.toArray();
                }
                bl.add(13);
                if (b != -1) continue;
                return bl.toArray();
            }
            bl.add(b);
        }
        return bl.isEmpty() ? null : bl.toArray();
    }

    private byte[] extractPart(byte[] sep, byte[] end, String enc) throws IOException {
        byte[] next;
        ByteList bl = new ByteList();
        while ((next = this.readLine()) != null && !Token.eq(next, sep)) {
            if (Token.eq(next, end)) {
                while (this.readLine() != null) {
                }
                break;
            }
            bl.add(next).add(10);
        }
        return new TextInput(new IOContent(bl.toArray())).encoding(enc).content();
    }

    private byte[] boundary(String ct) throws QueryException {
        int i = ct.toLowerCase(Locale.ENGLISH).indexOf("boundary=");
        if (i == -1) {
            throw Err.HC_REQ.get(this.info, "No separation boundary specified");
        }
        String b = ct.substring(i + "boundary=".length());
        if (b.charAt(0) == '\"') {
            i = b.lastIndexOf(34);
            b = b.substring(1, i);
        }
        return Token.token(b);
    }

    public HashMap<String, Value> multiForm(String ext) throws IOException, QueryException {
        byte[] line;
        byte[] bound = Token.concat(HTTPText.DASHES, this.boundary(ext));
        byte[] last = Token.concat(bound, HTTPText.DASHES);
        HashMap<String, Value> map = new HashMap<String, Value>();
        ByteList cont = new ByteList();
        int lines = -1;
        String name = null;
        String fn = null;
        while ((line = this.readLine()) != null) {
            if (lines >= 0) {
                if (Token.startsWith(line, bound)) {
                    Value val = map.get(name);
                    if (val == null && fn != null) {
                        val = Map.EMPTY;
                    }
                    if (fn != null && val instanceof Map) {
                        Map m = (Map)val;
                        Str k = Str.get(fn);
                        Value v = new ValueBuilder().add(m.get(k, this.info)).add(new B64(cont.toArray())).value();
                        val = m.insert(k, v, this.info);
                    } else {
                        val = Str.get(cont.toArray());
                    }
                    if (!name.isEmpty()) {
                        map.put(name, val);
                    }
                    cont.reset();
                    lines = -1;
                    if (!Token.eq(line, last)) continue;
                    break;
                }
                if (lines++ > 0) {
                    cont.add(HTTPText.CRLF);
                }
                cont.add(line);
                continue;
            }
            if (Token.startsWith(line, HTTPText.CONTENT_DISPOSITION)) {
                name = Token.contains(line, Token.token("name=")) ? Token.string(line).replaceAll("^.*?name=\"|\".*", "").replaceAll("\\[\\]", "") : null;
                fn = Token.contains(line, Token.token("filename=")) ? Token.string(line).replaceAll("^.*filename=\"|\"$", "") : null;
                continue;
            }
            if (line.length != 0) continue;
            lines = 0;
        }
        return map;
    }

    public static Value value(IO in, MainOptions opts, String ctype, String ext) throws IOException, QueryException {
        Value val = null;
        if (ctype != null) {
            if (MimeTypes.isJSON(ctype)) {
                JsonParserOptions jopts = new JsonParserOptions();
                if (Token.eq(ctype, "application/jsonml+json")) {
                    jopts.set(JsonOptions.FORMAT, JsonOptions.JsonFormat.JSONML);
                }
                val = new DBNode(new JsonParser(in, opts, jopts));
            } else if ("text/comma-separated-values".equals(ctype)) {
                val = new DBNode(new CsvParser(in, opts));
            } else if ("text/html".equals(ctype)) {
                val = new DBNode(new HtmlParser(in, opts));
            } else if ("application/x-www-form-urlencoded".equals(ctype)) {
                String enc = HTTPPayload.charset(ext);
                val = Str.get(URLDecoder.decode(Token.string(in.read()), enc == null ? "UTF-8" : enc));
            } else if (MimeTypes.isXML(ctype)) {
                val = new DBNode(in, opts);
            } else if (MimeTypes.isText(ctype)) {
                val = Str.get(new TextInput(in).content());
            } else if (MimeTypes.isMultipart(ctype)) {
                HTTPPayload hp = new HTTPPayload(in.inputStream(), true, null, opts);
                hp.extractParts(Token.concat(HTTPText.DASHES, hp.boundary(ext)), null);
                val = hp.payloads();
            }
        }
        return val == null ? new B64(in.read()) : val;
    }

    private static String contentType(String ctype) {
        if (ctype == null) {
            return "application/octet-stream";
        }
        int end = ctype.indexOf(59);
        return end == -1 ? ctype : ctype.substring(0, end);
    }

    private static String charset(String ctype) {
        if (ctype == null) {
            return null;
        }
        int i = ctype.toLowerCase(Locale.ENGLISH).indexOf("charset=");
        return i == -1 ? null : ctype.substring(i + "charset=".length());
    }
}

